/*
 * Decompiled with CFR 0.152.
 */
package tools.mdsd.mocore.framework.surrogate;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class TypedDistinctMultiMap<S>
implements Iterable<S> {
    private static final boolean DEFAULT_IGNORE_INHERITANCE = false;
    private final Map<Class<?>, Set<S>> data = new HashMap();

    public void put(S element) {
        Set elements = this.data.getOrDefault(element.getClass(), new HashSet());
        elements.add(element);
        this.data.put(element.getClass(), elements);
    }

    public <T extends S> List<T> get(Class<T> key) {
        return this.get(key, false);
    }

    public <T extends S> List<T> get(Class<T> key, boolean ignoreInheritance) {
        HashSet keys = new HashSet();
        keys.add(key);
        if (!ignoreInheritance) {
            for (Class<?> childKey : this.data.keySet()) {
                if (!key.isAssignableFrom(childKey)) continue;
                keys.add(childKey);
            }
        }
        HashSet objects = new HashSet();
        for (Class clazz : keys) {
            objects.addAll(this.data.getOrDefault(clazz, new HashSet()));
        }
        return objects.stream().map(key::cast).collect(Collectors.toList());
    }

    public void remove(S element) {
        Set<S> elements = this.data.get(element.getClass());
        if (Objects.nonNull(elements)) {
            elements.remove(element);
        }
    }

    public boolean containsKey(Class<?> key) {
        if (Objects.isNull(key)) {
            return false;
        }
        return this.data.containsKey(key);
    }

    public boolean containsElement(S element) {
        if (Objects.isNull(element)) {
            return false;
        }
        Set elements = this.data.getOrDefault(element.getClass(), new HashSet());
        return elements.contains(element);
    }

    @Override
    public Iterator<S> iterator() {
        Set values = this.data.values().stream().flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
        return values.iterator();
    }
}

