/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.analyzer.workflow.core.configurations.AbstractCodeGenerationWorkflowRunConfiguration;
import org.palladiosimulator.analyzer.workflow.jobs.CreatePluginProjectJob;

public abstract class AbstractCreateMetaDataFilesJob {
    protected AbstractCodeGenerationWorkflowRunConfiguration configuration;
    public static final String F_MANIFEST = "MANIFEST.MF";
    public static final String F_MANIFEST_FP = "META-INF/MANIFEST.MF";
    public static final String F_PLUGIN = "plugin.xml";
    public static final String F_FRAGMENT = "fragment.xml";
    public static final String F_PROPERTIES = ".properties";
    public static final String F_BUILD = "build.properties";
    public static final String F_CONTENT = "content.properties";

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        IProject project = CreatePluginProjectJob.getProject((String)this.configuration.getStoragePluginID());
        try {
            this.createPluginXml(project);
            this.createManifestMf(project);
            this.createBuildProperties(project);
            this.createAdditionalProperties(project);
        }
        catch (CoreException e) {
            throw new JobFailedException("Failed to create plugin metadata files", (Throwable)e);
        }
    }

    public String getName() {
        return "Create SimuCom Metadata Files";
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    private void createPluginXml(IProject project) throws CoreException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baos);
        this.writePluginXmlContent(out);
        out.close();
        IFile pluginXml = project.getFile(F_PLUGIN);
        if (!pluginXml.exists()) {
            pluginXml.create((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, null);
        }
    }

    protected abstract void writePluginXmlContent(PrintStream var1);

    private void createBuildProperties(IProject project) throws CoreException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baos);
        this.writeBuildPropertiesContent(out);
        out.close();
        IFile buildProperties = project.getFile(F_BUILD);
        if (!buildProperties.exists()) {
            buildProperties.create((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, null);
        }
    }

    protected abstract void writeBuildPropertiesContent(PrintStream var1);

    private void createManifestMf(IProject project) throws CoreException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baos);
        out.println("Manifest-Version: 1.0");
        out.println("Bundle-ManifestVersion: 2");
        out.println("Bundle-Name: SimuCom Instance Plug-in");
        out.println("Bundle-SymbolicName: " + project.getName() + ";singleton:=true");
        out.println("Bundle-Version: 1.0.0");
        out.println("Bundle-Activator: " + this.getBundleActivator());
        out.print("Require-Bundle: ");
        ArrayList<String> requiredBundles = new ArrayList<String>();
        requiredBundles.addAll(Arrays.asList(this.getRequiredBundles()));
        requiredBundles.addAll(this.configuration.getCodeGenerationRequiredBundles());
        out.println(StringUtils.join(requiredBundles, (String)",\n "));
        out.println("Bundle-ActivationPolicy: lazy");
        out.println("Bundle-ClassPath: bin/,");
        out.println(" .");
        out.println("Bundle-RequiredExecutionEnvironment: JavaSE-1.7");
        out.close();
        IFile manifestMf = project.getFile(F_MANIFEST_FP);
        if (!manifestMf.exists()) {
            manifestMf.create((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, null);
        }
    }

    protected abstract String[] getRequiredBundles();

    protected abstract String getBundleActivator();

    private void createAdditionalProperties(IProject project) throws CoreException {
        IFile contentProp;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baos);
        out.println("#####Contains data about the original models on which this project was built#####");
        if (this.configuration.getStoragePluginID() != null) {
            out.println("baseProjectID = " + this.configuration.getBaseProjectID());
            for (String path : this.configuration.getModelPaths()) {
                String fileEnding = path.substring(path.lastIndexOf(".") + 1);
                out.println(String.valueOf(fileEnding) + " = " + path);
            }
        }
        if (!(contentProp = project.getFile(F_CONTENT)).exists()) {
            contentProp.create((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, null);
        }
    }
}

