/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.tools.stereotypeapi;

import de.uka.ipd.sdq.dsexplore.tools.stereotypeapi.EMFProfileFilter;
import de.uka.ipd.sdq.dsexplore.tools.stereotypeapi.EcoreReferenceResolver;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.modelversioning.emfprofileapplication.StereotypeApplication;

public final class StereotypeAPIHelper {
    private StereotypeAPIHelper() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static <ElementType, Base extends EObject> List<ElementType> getViaStereoTypeFrom(Base base, Class<ElementType> target) {
        ArrayList<ElementType> res = new ArrayList<ElementType>();
        List<StereotypeApplication> appls = EMFProfileFilter.getStereotypeApplicationsFrom(base);
        for (StereotypeApplication appl : appls) {
            List<ElementType> provided = new EcoreReferenceResolver((EObject)appl).getCrossReferencedElementsOfType(target);
            res.addAll(provided);
        }
        return res;
    }

    public static <ElementType, Base extends EObject> List<ElementType> getViaStereoTypeFrom(Base base, Class<ElementType> target, String stereotype) {
        ArrayList<ElementType> res = new ArrayList<ElementType>();
        List<StereotypeApplication> appls = EMFProfileFilter.getStereotypeApplicationsFrom(base);
        for (StereotypeApplication appl : appls) {
            if (!appl.getStereotype().getName().equalsIgnoreCase(stereotype)) continue;
            List<ElementType> provided = new EcoreReferenceResolver((EObject)appl).getCrossReferencedElementsOfType(target);
            res.addAll(provided);
        }
        return res;
    }

    public static StereotypeApplication getStereotype(EObject base, String stereotype) {
        List<StereotypeApplication> appls = EMFProfileFilter.getStereotypeApplicationsFrom(base);
        for (StereotypeApplication appl : appls) {
            if (!appl.getStereotype().getName().equalsIgnoreCase(stereotype)) continue;
            return appl;
        }
        return null;
    }
}

