/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.designdecisions.alternativecomponents;

import de.uka.ipd.sdq.dsexplore.designdecisions.alternativecomponents.ComponentReplacer;
import de.uka.ipd.sdq.dsexplore.designdecisions.alternativecomponents.ConnectorAdjuster;
import de.uka.ipd.sdq.dsexplore.designdecisions.alternativecomponents.IncomingAssemblyConnectorAdjuster;
import de.uka.ipd.sdq.dsexplore.designdecisions.alternativecomponents.OutgoingAssemblyConnectorAdjuster;
import de.uka.ipd.sdq.dsexplore.designdecisions.alternativecomponents.ProvidedDelegationConnectorReplacer;
import de.uka.ipd.sdq.dsexplore.designdecisions.alternativecomponents.RequiredDelegationConnectorAdjuster;
import de.uka.ipd.sdq.dsexplore.helper.EMFHelper;
import de.uka.ipd.sdq.dsexplore.helper.EntityComparator;
import de.uka.ipd.sdq.pcm.designdecision.specific.AssembledComponentDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.impl.specificFactoryImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.solver.core.models.PCMInstance;

public class AlternativeComponent {
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore");
    Map<AssemblyContext, Map<RepositoryComponent, ComponentReplacer>> alternativeMap = null;
    private static AlternativeComponent instance = new AlternativeComponent();

    private AlternativeComponent() {
    }

    public static AlternativeComponent getInstance() {
        return instance;
    }

    public List<AssembledComponentDegree> generateDesignDecisions(PCMInstance pcmInstance) {
        List repositories = pcmInstance.getRepositories();
        System s = pcmInstance.getSystem();
        ArrayList<RepositoryComponent> repoComponents = new ArrayList<RepositoryComponent>(15);
        for (Repository repository : repositories) {
            repoComponents.addAll((Collection<RepositoryComponent>)repository.getComponents__Repository());
        }
        this.alternativeMap = this.findAlternatives(repoComponents, (List<AssemblyContext>)s.getAssemblyContexts__ComposedStructure(), s);
        logger.debug((Object)("I have a mapping for " + this.alternativeMap.size() + " AssemblyContexts with the following alternatives:"));
        return this.createAssembledComponentDecisionsInstances(pcmInstance, this.alternativeMap);
    }

    private List<AssembledComponentDegree> createAssembledComponentDecisionsInstances(PCMInstance pcmInstance, Map<AssemblyContext, Map<RepositoryComponent, ComponentReplacer>> alternativeMap2) {
        ArrayList<AssembledComponentDegree> l = new ArrayList<AssembledComponentDegree>();
        for (Map.Entry<AssemblyContext, Map<RepositoryComponent, ComponentReplacer>> mapping : alternativeMap2.entrySet()) {
            logger.debug((Object)("Assembly context " + mapping.getKey().getEntityName() + " has " + mapping.getValue().size() + " fitting component(s)."));
            if (mapping.getValue().size() <= 1) continue;
            AssembledComponentDegree inst = this.createDesignDecision(pcmInstance, mapping);
            l.add(inst);
        }
        return l;
    }

    private AssembledComponentDegree createDesignDecision(PCMInstance pcmInstance, Map.Entry<AssemblyContext, Map<RepositoryComponent, ComponentReplacer>> mappingEntry) {
        AssembledComponentDegree decision = specificFactoryImpl.eINSTANCE.createAssembledComponentDegree();
        decision.getClassDesignOptions().addAll(mappingEntry.getValue().keySet());
        decision.setPrimaryChanged((EObject)mappingEntry.getKey());
        return decision;
    }

    public void applyChange(AssemblyContext changedAssemblyContext, RepositoryComponent newComponent) {
        if (this.alternativeMap == null) {
            throw new RuntimeException("The AlternativeComponent operator has not properly been initialized. Check previous Exceptions or contact the developers.");
        }
        changedAssemblyContext.setEncapsulatedComponent__AssemblyContext(newComponent);
        Map<RepositoryComponent, ComponentReplacer> map = this.alternativeMap.get(changedAssemblyContext);
        ComponentReplacer componentReplacer = map.get(newComponent);
        componentReplacer.replace();
    }

    private Map<AssemblyContext, Map<RepositoryComponent, ComponentReplacer>> findAlternatives(List<RepositoryComponent> repoComponents, List<AssemblyContext> assemblyContexts, System s) {
        EntityComparator c = new EntityComparator();
        TreeMap<Entity, Map<RepositoryComponent, ComponentReplacer>> alternativeMap = new TreeMap<Entity, Map<RepositoryComponent, ComponentReplacer>>(c);
        for (AssemblyContext assemblyContext : assemblyContexts) {
            Map<RepositoryComponent, ComponentReplacer> map = this.getAlternatives(assemblyContext, repoComponents, s);
            if (map.size() <= 0) continue;
            alternativeMap.put((Entity)assemblyContext, map);
        }
        return alternativeMap;
    }

    private Map<RepositoryComponent, ComponentReplacer> getAlternatives(AssemblyContext assemblyContext, List<RepositoryComponent> repoComponents, System s) {
        EntityComparator c = new EntityComparator();
        TreeMap<Entity, ComponentReplacer> map = new TreeMap<Entity, ComponentReplacer>(c);
        for (RepositoryComponent repoComponent : repoComponents) {
            ComponentReplacer p = this.findRoleMappingFor(assemblyContext, repoComponent, s);
            if (p == null) continue;
            map.put((Entity)repoComponent, p);
            logger.debug((Object)("Found an alternative: " + assemblyContext.getEntityName() + " can encapsulate the component " + repoComponent.getEntityName() + "."));
        }
        return map;
    }

    private ComponentReplacer findRoleMappingFor(AssemblyContext assemblyContext, RepositoryComponent alternativeComponent, System s) {
        RepositoryComponent assembledComponent = assemblyContext.getEncapsulatedComponent__AssemblyContext();
        ComponentReplacer cr = new ComponentReplacer();
        EList altprl = alternativeComponent.getProvidedRoles_InterfaceProvidingEntity();
        EList assprl = assembledComponent.getProvidedRoles_InterfaceProvidingEntity();
        IdentityHashMap<OperationProvidedRole, OperationProvidedRole> providedMapping = new IdentityHashMap<OperationProvidedRole, OperationProvidedRole>();
        block0: for (ProvidedRole asspr : assprl) {
            if (!(asspr instanceof OperationProvidedRole)) continue;
            OperationProvidedRole assembledOperationProvidedRole = (OperationProvidedRole)asspr;
            for (ProvidedRole altpr : altprl) {
                OperationProvidedRole alternativeOperationProvidedRole;
                if (!(altpr instanceof OperationProvidedRole) || !EMFHelper.checkIdentity((EObject)(alternativeOperationProvidedRole = (OperationProvidedRole)altpr).getProvidedInterface__OperationProvidedRole(), (EObject)assembledOperationProvidedRole.getProvidedInterface__OperationProvidedRole())) continue;
                providedMapping.put(assembledOperationProvidedRole, alternativeOperationProvidedRole);
                continue block0;
            }
        }
        if (providedMapping.size() != assprl.size()) {
            return null;
        }
        List<ConnectorAdjuster> cas = this.findProvidedConnectors(assemblyContext, s, providedMapping);
        cr.addAllConnectorAdjuster(cas);
        logger.debug((Object)("These two have matching provided interfaces:" + assembledComponent.getEntityName() + " and " + alternativeComponent.getEntityName()));
        EList altrrl = alternativeComponent.getRequiredRoles_InterfaceRequiringEntity();
        EList assrrl = assembledComponent.getRequiredRoles_InterfaceRequiringEntity();
        IdentityHashMap<OperationRequiredRole, OperationRequiredRole> requiredMapping = new IdentityHashMap<OperationRequiredRole, OperationRequiredRole>();
        for (RequiredRole altrr : altrrl) {
            if (!(altrr instanceof OperationRequiredRole)) continue;
            OperationRequiredRole alternativeOperationRequiredRole = (OperationRequiredRole)altrr;
            boolean foundMatch = false;
            for (RequiredRole assrr : assrrl) {
                if (!(assrr instanceof OperationRequiredRole)) continue;
                OperationRequiredRole assembledOperationRequiredRole = (OperationRequiredRole)assrr;
                if (!EMFHelper.checkIdentity((EObject)alternativeOperationRequiredRole.getRequiredInterface__OperationRequiredRole(), (EObject)assembledOperationRequiredRole.getRequiredInterface__OperationRequiredRole())) continue;
                requiredMapping.put(assembledOperationRequiredRole, alternativeOperationRequiredRole);
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return null;
        }
        if (requiredMapping.size() != altrrl.size()) {
            return null;
        }
        List<ConnectorAdjuster> cas2 = this.findRequiredConnectors(assemblyContext, s, requiredMapping);
        cr.addAllConnectorAdjuster(cas2);
        logger.debug((Object)("These two have matching required interfaces:" + assembledComponent.getEntityName() + " and " + alternativeComponent.getEntityName()));
        return cr;
    }

    private List<ConnectorAdjuster> findRequiredConnectors(AssemblyContext assemblyContext, System s, Map<OperationRequiredRole, OperationRequiredRole> requiredMapping) {
        OperationRequiredRole role;
        ArrayList<ConnectorAdjuster> result = new ArrayList<ConnectorAdjuster>();
        for (Connector conn : s.getConnectors__ComposedStructure()) {
            AssemblyConnector assemblyConnector;
            if (!(conn instanceof AssemblyConnector) || !EMFHelper.checkIdentity((EObject)(assemblyConnector = (AssemblyConnector)conn).getRequiringAssemblyContext_AssemblyConnector(), (EObject)assemblyContext)) continue;
            role = requiredMapping.get(assemblyConnector.getRequiredRole_AssemblyConnector());
            result.add(new OutgoingAssemblyConnectorAdjuster(assemblyConnector, role));
        }
        for (Connector conn : s.getConnectors__ComposedStructure()) {
            RequiredDelegationConnector requiredDelegationConnector;
            if (!(conn instanceof RequiredDelegationConnector) || !EMFHelper.checkIdentity((EObject)(requiredDelegationConnector = (RequiredDelegationConnector)conn).getInnerRequiredRole_RequiredDelegationConnector(), (EObject)assemblyContext)) continue;
            role = requiredMapping.get(requiredDelegationConnector.getInnerRequiredRole_RequiredDelegationConnector());
            result.add(new RequiredDelegationConnectorAdjuster(requiredDelegationConnector, role));
        }
        return result;
    }

    private List<ConnectorAdjuster> findProvidedConnectors(AssemblyContext assemblyContext, System s, Map<OperationProvidedRole, OperationProvidedRole> providedMapping) {
        OperationProvidedRole role;
        ArrayList<ConnectorAdjuster> result = new ArrayList<ConnectorAdjuster>();
        for (Connector conn : s.getConnectors__ComposedStructure()) {
            AssemblyConnector assemblyConnector;
            if (!(conn instanceof AssemblyConnector) || !EMFHelper.checkIdentity((EObject)(assemblyConnector = (AssemblyConnector)conn).getProvidingAssemblyContext_AssemblyConnector(), (EObject)assemblyContext)) continue;
            role = providedMapping.get(assemblyConnector.getProvidedRole_AssemblyConnector());
            result.add(new IncomingAssemblyConnectorAdjuster(assemblyConnector, role));
        }
        for (Connector conn : s.getConnectors__ComposedStructure()) {
            ProvidedDelegationConnector providedDelegationConnector;
            if (!(conn instanceof ProvidedDelegationConnector) || !EMFHelper.checkIdentity((EObject)(providedDelegationConnector = (ProvidedDelegationConnector)conn).getAssemblyContext_ProvidedDelegationConnector(), (EObject)assemblyContext)) continue;
            role = providedMapping.get(providedDelegationConnector.getInnerProvidedRole_ProvidedDelegationConnector());
            result.add(new ProvidedDelegationConnectorReplacer(providedDelegationConnector, role));
        }
        return result;
    }
}

