package de.uka.ipd.sdq.pcm.codegen.simucom.transformations;

import java.util.Arrays;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.palladiosimulator.pcm.repository.CollectionDataType;
import org.palladiosimulator.pcm.repository.CompositeDataType;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.PrimitiveDataType;
import org.palladiosimulator.pcm.repository.PrimitiveTypeEnum;

@SuppressWarnings("all")
public class DataTypesXpt {
  protected String _dataType(final DataType type) {
    return null;
  }

  protected String _dataType(final PrimitiveDataType type) {
    String _switchResult = null;
    PrimitiveTypeEnum _type = type.getType();
    if (_type != null) {
      switch (_type) {
        case INT:
          _switchResult = "int";
          break;
        case DOUBLE:
          _switchResult = "double";
          break;
        case CHAR:
          _switchResult = "char";
          break;
        case BYTE:
          _switchResult = "byte";
          break;
        case STRING:
          _switchResult = "String";
          break;
        default:
          break;
      }
    }
    return _switchResult;
  }

  protected String _dataType(final CollectionDataType type) {
    StringConcatenation _builder = new StringConcatenation();
    String _dataType = this.dataType(type.getInnerType_CollectionDataType());
    _builder.append(_dataType);
    _builder.append("[]");
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }

  protected String _dataType(final CompositeDataType type) {
    StringConcatenation _builder = new StringConcatenation();
    String _entityName = type.getEntityName();
    _builder.append(_entityName);
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }

  public String dataType(final DataType type) {
    if (type instanceof CollectionDataType) {
      return _dataType((CollectionDataType)type);
    } else if (type instanceof CompositeDataType) {
      return _dataType((CompositeDataType)type);
    } else if (type instanceof PrimitiveDataType) {
      return _dataType((PrimitiveDataType)type);
    } else if (type != null) {
      return _dataType(type);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(type).toString());
    }
  }
}
