package de.uka.ipd.sdq.pcm.codegen.simucom.transformations.sim;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaNamesExt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.UsageXpt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.UserActionsXpt;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.Branch;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.pcm.usagemodel.Delay;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Loop;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.Stop;

@SuppressWarnings("all")
public class SimUserActionsXpt extends UserActionsXpt {
  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;

  @Inject
  @Extension
  private UsageXpt _usageXpt;

  @Override
  protected CharSequence _userAction(final Loop _this) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("for (int iterationCount_");
    String _javaVariableName = this._javaNamesExt.javaVariableName(_this.getId());
    _builder.append(_javaVariableName);
    _builder.append(" = 0, maxIterationCount_");
    String _javaVariableName_1 = this._javaNamesExt.javaVariableName(_this.getId());
    _builder.append(_javaVariableName_1);
    _builder.append(" = (Integer)ctx.evaluate(\"");
    String _specificationString = this._javaNamesExt.specificationString(_this.getLoopIteration_Loop().getSpecification());
    _builder.append(_specificationString);
    _builder.append("\",Integer.class); ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("iterationCount_");
    String _javaVariableName_2 = this._javaNamesExt.javaVariableName(_this.getId());
    _builder.append(_javaVariableName_2, "\t");
    _builder.append(" < maxIterationCount_");
    String _javaVariableName_3 = this._javaNamesExt.javaVariableName(_this.getId());
    _builder.append(_javaVariableName_3, "\t");
    _builder.append("; iterationCount_");
    String _javaVariableName_4 = this._javaNamesExt.javaVariableName(_this.getId());
    _builder.append(_javaVariableName_4, "\t");
    _builder.append("++){");
    _builder.newLineIfNotEmpty();
    String _userActions = this._usageXpt.userActions(IterableExtensions.<Start>head(Iterables.<Start>filter(_this.getBodyBehaviour_Loop().getActions_ScenarioBehaviour(), Start.class)));
    _builder.append(_userActions);
    _builder.newLineIfNotEmpty();
    _builder.append("} ");
    _builder.newLine();
    return _builder;
  }

  @Override
  protected CharSequence _userAction(final Branch _this) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    final String counterID = this._javaNamesExt.javaVariableName(_this.getId());
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("double u");
    _builder.append(counterID, "\t");
    _builder.append(" = ctx.getModel().getConfiguration().getRandomGenerator().random();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("double sum");
    _builder.append(counterID, "\t");
    _builder.append(" = 0;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    {
      EList<BranchTransition> _branchTransitions_Branch = _this.getBranchTransitions_Branch();
      boolean _hasElements = false;
      for(final BranchTransition bt : _branchTransitions_Branch) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate("", "\t");
        }
        CharSequence _branchTransition = this.branchTransition(bt, counterID);
        _builder.append(_branchTransition, "\t");
      }
    }
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence branchTransition(final BranchTransition _this, final String counterNumber) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("if (sum");
    _builder.append(counterNumber);
    _builder.append(" <= u");
    _builder.append(counterNumber);
    _builder.append(" && u");
    _builder.append(counterNumber);
    _builder.append(" < sum");
    _builder.append(counterNumber);
    _builder.append(" + ");
    double _branchProbability = _this.getBranchProbability();
    _builder.append(_branchProbability);
    _builder.append(" )");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    String _userActions = this._usageXpt.userActions(IterableExtensions.<Start>head(Iterables.<Start>filter(_this.getBranchedBehaviour_BranchTransition().getActions_ScenarioBehaviour(), Start.class)));
    _builder.append(_userActions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.append("sum");
    _builder.append(counterNumber);
    _builder.append(" += ");
    double _branchProbability_1 = _this.getBranchProbability();
    _builder.append(_branchProbability_1);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @Override
  protected CharSequence _userAction(final Delay _this) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("{");
    _builder.newLine();
    _builder.append("double delay = de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter.toDouble(ctx.evaluate(\"");
    String _specification = _this.getTimeSpecification_Delay().getSpecification();
    _builder.append(_specification);
    _builder.append("\"));");
    _builder.newLineIfNotEmpty();
    _builder.append("ctx.getThread().hold(delay);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  @Override
  protected CharSequence _userAction(final Stop _this) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  @Override
  public CharSequence userAction(final AbstractUserAction _this) {
    if (_this instanceof Branch) {
      return _userAction((Branch)_this);
    } else if (_this instanceof Delay) {
      return _userAction((Delay)_this);
    } else if (_this instanceof EntryLevelSystemCall) {
      return _userAction((EntryLevelSystemCall)_this);
    } else if (_this instanceof Loop) {
      return _userAction((Loop)_this);
    } else if (_this instanceof Start) {
      return _userAction((Start)_this);
    } else if (_this instanceof Stop) {
      return _userAction((Stop)_this);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(_this).toString());
    }
  }
}
