/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.print;

import de.uka.ipd.sdq.probfunction.BoxedPDF;
import de.uka.ipd.sdq.probfunction.ContinuousSample;
import de.uka.ipd.sdq.probfunction.ExponentialDistribution;
import de.uka.ipd.sdq.probfunction.GammaDistribution;
import de.uka.ipd.sdq.probfunction.LognormalDistribution;
import de.uka.ipd.sdq.probfunction.NormalDistribution;
import de.uka.ipd.sdq.probfunction.ProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.Sample;
import de.uka.ipd.sdq.probfunction.util.ProbfunctionSwitch;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class ProbFunctionPrettyPrint
extends ProbfunctionSwitch<String> {
    private static final int AVERAGE_PROBFUNCTION_LENGTH = 50;
    private final StringBuilder resultBuilder;
    private static final DecimalFormat df = new DecimalFormat("#0.0#######", new DecimalFormatSymbols(Locale.US));

    public ProbFunctionPrettyPrint() {
        this(new StringBuilder(50));
    }

    public ProbFunctionPrettyPrint(StringBuilder builder) {
        this.resultBuilder = builder;
    }

    @Override
    public String caseBoxedPDF(BoxedPDF object) {
        this.resultBuilder.append("DoublePDF[");
        for (ContinuousSample s : object.getSamples()) {
            this.resultBuilder.append(String.format("(%s; %s)", df.format(s.getValue()), df.format(s.getProbability())));
        }
        this.resultBuilder.append("]");
        return this.resultBuilder.toString();
    }

    @Override
    public <T> String caseProbabilityMassFunction(ProbabilityMassFunction<T> object) {
        Sample sample = (Sample)object.getSamples().get(0);
        String pmfType = this.detectType(sample);
        String leftSeparator = "";
        String rightSeparator = ";";
        if (pmfType.equals("EnumPMF")) {
            leftSeparator = "\"";
            rightSeparator = "\";";
        }
        this.resultBuilder.append(pmfType);
        this.resultBuilder.append("[");
        for (Sample s : object.getSamples()) {
            this.resultBuilder.append(String.format("(%s%s%s %s)", leftSeparator, s.getValue(), rightSeparator, df.format(s.getProbability())));
        }
        this.resultBuilder.append("]");
        return this.resultBuilder.toString();
    }

    @Override
    public String caseExponentialDistribution(ExponentialDistribution object) {
        this.resultBuilder.append(String.format("Exp(%s)", df.format(object.getRate())));
        return this.resultBuilder.toString();
    }

    @Override
    public String caseGammaDistribution(GammaDistribution object) {
        this.resultBuilder.append(String.format("Gamma(%s, %s)", df.format(object.getAlpha()), df.format(object.getTheta())));
        return this.resultBuilder.toString();
    }

    @Override
    public String caseLognormalDistribution(LognormalDistribution object) {
        this.resultBuilder.append(String.format("Lognorm(%s, %s)", df.format(object.getMu()), df.format(object.getSigma())));
        return this.resultBuilder.toString();
    }

    @Override
    public String caseNormalDistribution(NormalDistribution object) {
        this.resultBuilder.append(String.format("Norm(%s, %s)", df.format(object.getMu()), df.format(object.getSigma())));
        return this.resultBuilder.toString();
    }

    private String detectType(Sample<?> object) {
        if (object.getValue() instanceof Integer) {
            return "IntPMF";
        }
        if (object.getValue() instanceof Double) {
            return "DoublePMF";
        }
        if (object.getValue().equals("true") || object.getValue().equals("false") || object.getValue() instanceof Boolean) {
            return "BoolPMF";
        }
        if (object.getValue() instanceof String) {
            return "EnumPMF";
        }
        throw new UnsupportedOperationException("Unknown PMF found!");
    }
}

