/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dialogs.dataset;

import de.uka.ipd.sdq.sensorframework.SensorFrameworkDataset;
import de.uka.ipd.sdq.sensorframework.dao.file.FileDAOFactory;
import de.uka.ipd.sdq.sensorframework.dialogs.SensorFrameworkDialogPlugin;
import de.uka.ipd.sdq.sensorframework.dialogs.dataset.WizardDatasourceLoadPage;
import de.uka.ipd.sdq.sensorframework.dialogs.dataset.WizardSelectDatasourcePage;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class OpenDatasourceWizard
extends Wizard {
    private WizardDatasourceLoadPage db40DatasourceLoadPage;
    private WizardDatasourceLoadPage fileDatasourceLoadPage;
    private WizardSelectDatasourcePage selectDatasourceTypePage;

    public OpenDatasourceWizard() {
        this.setWindowTitle("Load datastore...");
    }

    public void addPages() {
        super.addPages();
        this.selectDatasourceTypePage = new WizardSelectDatasourcePage("Select Type of Datasource to load", false, true, true);
        this.addPage((IWizardPage)this.selectDatasourceTypePage);
        this.db40DatasourceLoadPage = new WizardDatasourceLoadPage("Open the database file", 1);
        this.addPage((IWizardPage)this.db40DatasourceLoadPage);
        this.fileDatasourceLoadPage = new WizardDatasourceLoadPage("Open the database folder", 2);
        this.addPage((IWizardPage)this.fileDatasourceLoadPage);
    }

    public boolean performFinish() {
        FileDAOFactory factory = null;
        IPath path = null;
        if (this.selectDatasourceTypePage.getResult().equals(WizardSelectDatasourcePage.FILE_DATASRC)) {
            path = this.fileDatasourceLoadPage.getFileFullPath();
            try {
                factory = new FileDAOFactory(path.toOSString());
                SensorFrameworkDataset.singleton().addDataSource((IDAOFactory)factory);
            }
            catch (Throwable e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"File DAO factory error.", (String)e.getMessage());
                SensorFrameworkDialogPlugin.log(4, e.getMessage());
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean canFinish() {
        if (this.selectDatasourceTypePage.getResult().equals(WizardSelectDatasourcePage.FILE_DATASRC)) {
            return this.fileDatasourceLoadPage.isPageComplete();
        }
        return false;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        WizardSelectDatasourcePage data_type_page;
        if (page instanceof WizardSelectDatasourcePage && (data_type_page = (WizardSelectDatasourcePage)page).getResult().equals(WizardSelectDatasourcePage.FILE_DATASRC)) {
            return this.fileDatasourceLoadPage;
        }
        return null;
    }
}

