/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.filter;

import de.uka.ipd.sdq.sensorframework.entities.Measurement;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanMeasurement;
import de.uka.ipd.sdq.sensorframework.filter.AbstractMeasurementsCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class OutlierFilteredCollection
extends AbstractMeasurementsCollection {
    private final double parameter;

    public OutlierFilteredCollection(Collection<Measurement> originalMeasurements, double parameter) {
        super(originalMeasurements);
        this.parameter = parameter;
    }

    @Override
    protected void applyFilter(Collection<Measurement> filteredItemsList) {
        int outlierNumber = 0;
        outlierNumber = (int)(this.parameter * (double)this.originalMeasurements.size());
        ArrayList<TimeSpanMeasurement> sortedMeasurements = new ArrayList<TimeSpanMeasurement>();
        Iterator it = this.originalMeasurements.iterator();
        while (it.hasNext()) {
            sortedMeasurements.add((TimeSpanMeasurement)it.next());
        }
        Collections.sort(sortedMeasurements, new Comparator<TimeSpanMeasurement>(){

            @Override
            public int compare(TimeSpanMeasurement o1, TimeSpanMeasurement o2) {
                return Double.compare(o1.getTimeSpan(), o2.getTimeSpan());
            }
        });
        int i = sortedMeasurements.size() - 1;
        while (i >= sortedMeasurements.size() - outlierNumber) {
            filteredItemsList.add((Measurement)sortedMeasurements.get(i));
            --i;
        }
    }
}

