/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.dao.memory;

import de.uka.ipd.sdq.sensorframework.entities.ScalabilitySensor;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.State;
import de.uka.ipd.sdq.sensorframework.entities.StateSensor;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanSensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import de.uka.ipd.sdq.sensorframework.entities.dao.ISensorDAO;
import de.uka.ipd.sdq.sensorframework.entities.impl.ScalabilitySensorImpl;
import de.uka.ipd.sdq.sensorframework.entities.impl.StateSensorImpl;
import de.uka.ipd.sdq.sensorframework.entities.impl.TimeSpanSensorImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class MemorySensorDAO
implements ISensorDAO {
    private final IDAOFactory myFactory;
    private long nextID = 0L;
    private final HashMap<Long, Sensor> index = new HashMap();

    public MemorySensorDAO(IDAOFactory memoryDAOFactory) {
        this.myFactory = memoryDAOFactory;
    }

    @Override
    public synchronized StateSensor addStateSensor(State p_initialstate, String p_sensorname) {
        StateSensorImpl result = new StateSensorImpl(this.myFactory);
        result.setSensorID(this.nextID++);
        result.setInitialState(p_initialstate);
        result.setSensorName(p_sensorname);
        this.index.put(result.getSensorID(), result);
        return result;
    }

    @Override
    public synchronized TimeSpanSensor addTimeSpanSensor(String p_sensorname) {
        TimeSpanSensorImpl result = new TimeSpanSensorImpl(this.myFactory);
        result.setSensorID(this.nextID++);
        result.setSensorName(p_sensorname);
        this.index.put(result.getSensorID(), result);
        return result;
    }

    @Override
    public synchronized ScalabilitySensor addScalabilitySensor(String p_sensorname) {
        ScalabilitySensorImpl result = new ScalabilitySensorImpl(this.myFactory);
        result.setSensorID(this.nextID++);
        result.setSensorName(p_sensorname);
        this.index.put(result.getSensorID(), result);
        return result;
    }

    @Override
    public synchronized Sensor get(long id) {
        if (!this.index.containsKey(id)) {
            throw new RuntimeException("Attempt to retrieve non-existing sensor.");
        }
        return this.index.get(id);
    }

    @Override
    public synchronized Collection<Sensor> getSensors() {
        return Collections.unmodifiableCollection(this.index.values());
    }

    @Override
    public synchronized Collection<Sensor> findBySensorName(String searchKey) {
        ArrayList<Sensor> result = new ArrayList<Sensor>();
        for (Sensor e : this.index.values()) {
            if (!e.getSensorName().equals(searchKey)) continue;
            result.add(e);
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public synchronized void removeSensor(Sensor sensor, boolean doCascade) {
        if (sensor == null) {
            return;
        }
        if (doCascade && sensor instanceof StateSensor) {
            for (State state : ((StateSensor)sensor).getSensorStates()) {
                this.myFactory.createStateDAO().removeState(state, true);
            }
        }
        this.index.remove(sensor.getSensorID());
    }

    public void store(Sensor s) {
    }

    @Override
    public void storeAll() {
    }
}

