/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.entities.base;

import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.ScalabilitySensor;
import de.uka.ipd.sdq.sensorframework.entities.Sensor;
import de.uka.ipd.sdq.sensorframework.entities.State;
import de.uka.ipd.sdq.sensorframework.entities.StateSensor;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanSensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractExperiment
implements Experiment {
    protected transient IDAOFactory myDAOFactory = null;
    private long m_experimentID;
    private String m_experimentName;
    private final Collection<Sensor> m_sensors = new ArrayList<Sensor>();
    private final Collection<ExperimentRun> m_experimentRuns = new ArrayList<ExperimentRun>();

    public AbstractExperiment(IDAOFactory myFactory) {
        this.myDAOFactory = myFactory;
    }

    @Override
    public long getExperimentID() {
        return this.m_experimentID;
    }

    @Override
    public void setExperimentID(long value) {
        this.m_experimentID = value;
    }

    @Override
    public String getExperimentName() {
        return this.m_experimentName;
    }

    @Override
    public void setExperimentName(String value) {
        this.m_experimentName = value;
    }

    @Override
    public StateSensor addStateSensor(State p_initialstate, String p_sensorname) {
        StateSensor result = this.myDAOFactory.createSensorDAO().addStateSensor(p_initialstate, p_sensorname);
        this.m_sensors.add(result);
        return result;
    }

    @Override
    public TimeSpanSensor addTimeSpanSensor(String p_sensorname) {
        TimeSpanSensor result = this.myDAOFactory.createSensorDAO().addTimeSpanSensor(p_sensorname);
        this.m_sensors.add(result);
        return result;
    }

    @Override
    public ScalabilitySensor addScalabilitySensor(String p_sensorname) {
        ScalabilitySensor result = this.myDAOFactory.createSensorDAO().addScalabilitySensor(p_sensorname);
        this.m_sensors.add(result);
        return result;
    }

    @Override
    public void addSensor(Sensor value) {
        this.m_sensors.add(value);
    }

    @Override
    public Collection<Sensor> getSensors() {
        return this.m_sensors;
    }

    @Override
    public ExperimentRun addExperimentRun(String p_experimentdatetime) {
        ExperimentRun result = this.myDAOFactory.createExperimentRunDAO().addExperimentRun(p_experimentdatetime);
        this.m_experimentRuns.add(result);
        return result;
    }

    @Override
    public ExperimentRun addScalabilityExperimentRun(String p_experimentdatetime) {
        ExperimentRun result = this.myDAOFactory.createExperimentRunDAO().addScalabilityExperimentRun(p_experimentdatetime);
        this.m_experimentRuns.add(result);
        return result;
    }

    @Override
    public void addExperimentRun(ExperimentRun value) {
        this.m_experimentRuns.add(value);
    }

    @Override
    public Collection<ExperimentRun> getExperimentRuns() {
        return this.m_experimentRuns;
    }
}

