/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.core;

import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.core.resources.AbstractScheduledResource;
import de.uka.ipd.sdq.simucomframework.core.resources.AbstractSimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.core.resources.SimulatedLinkingResourceContainer;
import de.uka.ipd.sdq.simucomframework.core.resources.SimulatedResourceContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceRegistry {
    private final Map<String, AbstractSimulatedResourceContainer> resourceContainerHash = new HashMap<String, AbstractSimulatedResourceContainer>();
    private final SimuComModel myModel;

    public ResourceRegistry(SimuComModel model) {
        this.myModel = model;
    }

    public void addResourceContainer(SimulatedResourceContainer container) {
        assert (!this.resourceContainerHash.containsKey(container.getResourceContainerID()));
        this.resourceContainerHash.put(container.getResourceContainerID(), container);
    }

    public AbstractSimulatedResourceContainer createResourceContainer(String containerID) {
        if (!this.resourceContainerHash.containsKey(containerID)) {
            SimulatedResourceContainer container = new SimulatedResourceContainer(this.myModel, containerID);
            this.resourceContainerHash.put(container.getResourceContainerID(), container);
        }
        return this.resourceContainerHash.get(containerID);
    }

    public AbstractSimulatedResourceContainer createLinkingResourceContainer(String containerID) {
        if (!this.resourceContainerHash.containsKey(containerID)) {
            SimulatedLinkingResourceContainer container = new SimulatedLinkingResourceContainer(this.myModel, containerID);
            this.resourceContainerHash.put(containerID, container);
        }
        return this.resourceContainerHash.get(containerID);
    }

    public void addLinkingResourceContainer(SimulatedLinkingResourceContainer container) {
        assert (!this.resourceContainerHash.containsKey(container.getResourceContainerID()));
        this.resourceContainerHash.put(container.getResourceContainerID(), container);
    }

    public List<SimulatedLinkingResourceContainer> getLinkingResourceContainers() {
        ArrayList<SimulatedLinkingResourceContainer> resourceContainers = new ArrayList<SimulatedLinkingResourceContainer>();
        for (AbstractSimulatedResourceContainer container : this.resourceContainerHash.values()) {
            if (!(container instanceof SimulatedLinkingResourceContainer)) continue;
            resourceContainers.add((SimulatedLinkingResourceContainer)container);
        }
        return resourceContainers;
    }

    public List<SimulatedResourceContainer> getSimulatedResourceContainers() {
        ArrayList<SimulatedResourceContainer> resourceContainers = new ArrayList<SimulatedResourceContainer>();
        for (AbstractSimulatedResourceContainer container : this.resourceContainerHash.values()) {
            if (!(container instanceof SimulatedResourceContainer)) continue;
            resourceContainers.add((SimulatedResourceContainer)container);
        }
        return resourceContainers;
    }

    public boolean containsResourceContainer(String resourceContainerID) {
        return this.resourceContainerHash.containsKey(resourceContainerID);
    }

    public AbstractSimulatedResourceContainer getResourceContainer(String resourceContainerID) {
        assert (this.containsResourceContainer(resourceContainerID));
        return this.resourceContainerHash.get(resourceContainerID);
    }

    public AbstractSimulatedResourceContainer removeResourceContainerFromRegistry(String resourceContainerID) {
        AbstractSimulatedResourceContainer container = null;
        if (this.containsResourceContainer(resourceContainerID)) {
            container = this.resourceContainerHash.get(resourceContainerID);
            this.resourceContainerHash.remove(resourceContainerID);
        }
        return container;
    }

    public void activateAllActiveResources() {
        ArrayList<AbstractScheduledResource> resources = new ArrayList<AbstractScheduledResource>();
        for (AbstractSimulatedResourceContainer src : this.resourceContainerHash.values()) {
            resources.addAll(src.getActiveResources());
        }
        for (AbstractScheduledResource sar : resources) {
            sar.activateResource();
        }
    }

    public void deactivateAllActiveResources() {
        ArrayList<AbstractScheduledResource> resources = new ArrayList<AbstractScheduledResource>();
        for (AbstractSimulatedResourceContainer src : this.resourceContainerHash.values()) {
            resources.addAll(src.getActiveResources());
        }
        for (AbstractScheduledResource sar : resources) {
            sar.deactivateResource();
        }
    }

    public void deactivateAllPassiveResources() {
    }
}

