/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.variables.functions;

import de.uka.ipd.sdq.probfunction.math.IPDFFactory;
import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.simucomframework.variables.exceptions.FunctionParametersNotAcceptedException;
import de.uka.ipd.sdq.simucomframework.variables.exceptions.FunctionUnknownException;
import de.uka.ipd.sdq.simucomframework.variables.functions.CeilFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.ExpDistFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.GammaDistFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.GammaDistFunctionFromMoments;
import de.uka.ipd.sdq.simucomframework.variables.functions.IFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.LogFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.LogNormDistFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.LogNormDistFunctionFromMoments;
import de.uka.ipd.sdq.simucomframework.variables.functions.MaxDeviationFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.MaxFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.MinDeviationFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.MinFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.NormDistFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.PoissonDistFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.RoundFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.SqrtFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.TruncFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.UniDoubleDistFunction;
import de.uka.ipd.sdq.simucomframework.variables.functions.UniIntDistFunction;
import java.util.ArrayList;
import java.util.HashMap;

public class FunctionLib {
    private HashMap<String, IFunction> myFunctions = new HashMap();
    private IRandomGenerator randomStream;

    public FunctionLib(IRandomGenerator randomStream, IPDFFactory factory) {
        this.randomStream = randomStream;
        this.addStdFunctionsToLib(randomStream, factory);
    }

    private void addStdFunctionsToLib(IRandomGenerator randomGen, IPDFFactory factory) {
        this.myFunctions.put("Norm", new NormDistFunction(randomGen, factory));
        this.myFunctions.put("Exp", new ExpDistFunction(randomGen, factory));
        this.myFunctions.put("Pois", new PoissonDistFunction(randomGen, factory));
        this.myFunctions.put("UniDouble", new UniDoubleDistFunction(randomGen, factory));
        this.myFunctions.put("UniInt", new UniIntDistFunction(randomGen, factory));
        this.myFunctions.put("Trunc", new TruncFunction());
        this.myFunctions.put("Round", new RoundFunction());
        this.myFunctions.put("Ceil", new CeilFunction());
        this.myFunctions.put("Log", new LogFunction());
        this.myFunctions.put("Sqrt", new SqrtFunction());
        this.myFunctions.put("Lognorm", new LogNormDistFunction(randomGen, factory));
        this.myFunctions.put("LognormMoments", new LogNormDistFunctionFromMoments(randomGen, factory));
        this.myFunctions.put("Gamma", new GammaDistFunction(randomGen, factory));
        this.myFunctions.put("GammaMoments", new GammaDistFunctionFromMoments(randomGen, factory));
        this.myFunctions.put("Min", new MinFunction());
        this.myFunctions.put("Max", new MaxFunction());
        this.myFunctions.put("MinDeviation", new MinDeviationFunction());
        this.myFunctions.put("MaxDeviation", new MaxDeviationFunction());
    }

    public void addFunction(String id, IFunction f) {
        this.myFunctions.put(id, f);
    }

    public IRandomGenerator getRandomStream() {
        return this.randomStream;
    }

    public Object evaluate(String functionID, ArrayList<Object> parameterValues) {
        if (!this.myFunctions.containsKey(functionID)) {
            throw new FunctionUnknownException("Function " + functionID + " is unknown! Evaluation aborted");
        }
        IFunction f = this.myFunctions.get(functionID);
        if (!f.checkParameters(parameterValues)) {
            throw new FunctionParametersNotAcceptedException("Parameters passed to function " + functionID + " do not match function definition!");
        }
        return f.evaluate(parameterValues);
    }
}

