/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.variables.stackframe;

import de.uka.ipd.sdq.simucomframework.variables.exceptions.ValueNotInFrameException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SimulatedStackframe<T>
implements Serializable {
    private static final long serialVersionUID = 547392494342021941L;
    private static final Logger LOGGER = Logger.getLogger((String)SimulatedStackframe.class.getName());
    private SimulatedStackframe<T> parentFrame = null;
    private final HashMap<String, T> contents = new HashMap();

    public SimulatedStackframe(SimulatedStackframe<T> parent) {
        this.parentFrame = parent;
    }

    public SimulatedStackframe() {
        this.parentFrame = null;
    }

    public void addValue(String id, T value) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Value " + value + " added to stackframe under id " + id));
        }
        this.contents.put(id, value);
    }

    public boolean hasValue(String id) {
        return this.contents.containsKey(id) || this.parentFrame != null && this.parentFrame.hasValue(id);
    }

    public T getValue(String id) throws ValueNotInFrameException {
        if (this.contents.containsKey(id)) {
            return this.contents.get(id);
        }
        if (this.parentFrame != null) {
            return this.parentFrame.getValue(id);
        }
        throw new ValueNotInFrameException("Identifier " + id + " not found in stackframe!");
    }

    public SimulatedStackframe<T> copyFrame() {
        SimulatedStackframe<T> copy = new SimulatedStackframe<T>();
        for (String key : this.contents.keySet()) {
            copy.addValue(key, this.contents.get(key));
        }
        if (this.parentFrame != null) {
            copy.setParentFrame(this.parentFrame.copyFrame());
        }
        return copy;
    }

    private void setParentFrame(SimulatedStackframe<T> frame) {
        this.parentFrame = frame;
    }

    public ArrayList<Map.Entry<String, T>> getContents() {
        return this.getContentsRecursive(new HashMap());
    }

    private ArrayList<Map.Entry<String, T>> getContentsRecursive(HashMap<String, T> alreadyFound) {
        ArrayList<Map.Entry<String, T>> result = new ArrayList<Map.Entry<String, T>>();
        for (Map.Entry<String, T> e : this.contents.entrySet()) {
            if (alreadyFound.containsKey(e.getKey())) continue;
            alreadyFound.put(e.getKey(), e.getValue());
            result.add(e);
        }
        if (this.parentFrame != null) {
            result.addAll(this.parentFrame.getContentsRecursive(alreadyFound));
        }
        return result;
    }

    public void addVariables(SimulatedStackframe<T> callResult) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Adding " + callResult.getContents().size() + " value(s) to own stackframe"));
        }
        for (Map.Entry<String, T> e : callResult.contents.entrySet()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Adding " + e.getKey() + " with " + e.getValue()));
            }
            this.addValue(e.getKey(), e.getValue());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Map.Entry<String, T> entry : this.contents.entrySet()) {
            sb.append("(");
            sb.append(entry.getKey().toString());
            sb.append(", ");
            sb.append(entry.getValue().toString());
            sb.append(")");
        }
        sb.append("]");
        return sb.toString();
    }
}

