/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.stoex.analyser.operations;

import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.IProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.math.ISample;
import de.uka.ipd.sdq.probfunction.math.IUnit;
import de.uka.ipd.sdq.probfunction.math.impl.ProbabilityFunctionFactoryImpl;
import java.util.ArrayList;
import java.util.List;

public abstract class CompareOperation {
    private static final Object TRUE_STRING = "true";
    private static final Object FALSE_STRING = "false";

    public IProbabilityMassFunction compare(Object left, Object right) {
        if (left instanceof String) {
            if (((String)left).toLowerCase().equals(TRUE_STRING)) {
                left = new Boolean(true);
            } else if (((String)left).toLowerCase().equals(FALSE_STRING)) {
                left = new Boolean(false);
            }
        }
        if (right instanceof String) {
            if (((String)right).toLowerCase().equals(TRUE_STRING)) {
                right = new Boolean(true);
            } else if (((String)right).toLowerCase().equals(FALSE_STRING)) {
                right = new Boolean(false);
            }
        }
        if (left instanceof Double && right instanceof Double) {
            return this.getComparePMF((double)((Double)left), (double)((Double)right));
        }
        if (left instanceof IProbabilityMassFunction && right instanceof Double) {
            return this.getComparePMF((IProbabilityMassFunction)left, (double)((Double)right));
        }
        if (left instanceof Double && right instanceof IProbabilityMassFunction) {
            return this.getComparePMF((double)((Double)left), (IProbabilityMassFunction)right);
        }
        if (left instanceof IProbabilityMassFunction && right instanceof IProbabilityMassFunction) {
            return this.getComparePMF((IProbabilityMassFunction)left, (IProbabilityMassFunction)right);
        }
        if (left instanceof String && right instanceof String) {
            return this.getComparePMF((String)left, (String)right);
        }
        if (left instanceof String && right instanceof IProbabilityMassFunction) {
            return this.getComparePMF((String)left, (IProbabilityMassFunction)right);
        }
        if (left instanceof Boolean && right instanceof Boolean) {
            return this.getComparePMF((Boolean)left, (Boolean)right);
        }
        throw new UnsupportedOperationException();
    }

    public double comparePointWise(IProbabilityMassFunction left, IProbabilityMassFunction right, CompareOperation op) {
        List samplingPointsLeft = left.getSamples();
        List samplingPointsRight = right.getSamples();
        double probabilitySum = 0.0;
        for (ISample leftSamplingPoint : samplingPointsLeft) {
            Object leftValue = leftSamplingPoint.getValue();
            for (ISample rightSamplingPoint : samplingPointsRight) {
                Object rightValue = rightSamplingPoint.getValue();
                IProbabilityMassFunction boolPMF = op.compare(leftValue, rightValue);
                if (Double.valueOf(((ISample)boolPMF.getSamples().get(1)).getProbability()) != 1.0) continue;
                probabilitySum += leftSamplingPoint.getProbability() * rightSamplingPoint.getProbability();
            }
        }
        return probabilitySum;
    }

    public IProbabilityMassFunction getBoolPMF(double trueProb) {
        IProbabilityFunctionFactory probFac = IProbabilityFunctionFactory.eINSTANCE;
        IUnit unit = probFac.createUnit("bool");
        ArrayList<ISample> sampleList = new ArrayList<ISample>();
        sampleList.add(probFac.createSample(TRUE_STRING, trueProb));
        sampleList.add(probFac.createSample(FALSE_STRING, 1.0 - trueProb));
        IProbabilityMassFunction boolPMF = probFac.createProbabilityMassFunction(sampleList, unit, true);
        return boolPMF;
    }

    public double getProbabilityForValue(IProbabilityMassFunction iPMF, double valueToSeek) {
        List samplingPoints = iPMF.getSamples();
        for (ISample samplingPoint : samplingPoints) {
            Number valueNumber;
            Object value = samplingPoint.getValue();
            if (!(value instanceof Number) || (valueNumber = (Number)samplingPoint.getValue()).doubleValue() != valueToSeek) continue;
            return samplingPoint.getProbability();
        }
        return 0.0;
    }

    public double getThresholdProbability(IProbabilityMassFunction iPMF, double threshold, boolean includeThreshold) {
        double probabilitySum = 0.0;
        for (ISample sample : iPMF.getSamples()) {
            Object sampleValueObject = sample.getValue();
            if (sampleValueObject instanceof Number) {
                Double sampleValue = ((Number)sampleValueObject).doubleValue();
                if (sampleValue > threshold) {
                    return probabilitySum;
                }
                if (sampleValue == threshold) {
                    return includeThreshold ? probabilitySum + sample.getProbability() : probabilitySum;
                }
                probabilitySum += sample.getProbability();
                continue;
            }
            throw new UnsupportedOperationException();
        }
        return 0.0;
    }

    protected abstract IProbabilityMassFunction getComparePMF(boolean var1, boolean var2);

    protected abstract IProbabilityMassFunction getComparePMF(double var1, double var3);

    protected abstract IProbabilityMassFunction getComparePMF(double var1, IProbabilityMassFunction var3);

    protected abstract IProbabilityMassFunction getComparePMF(IProbabilityMassFunction var1, double var2);

    protected abstract IProbabilityMassFunction getComparePMF(IProbabilityMassFunction var1, IProbabilityMassFunction var2);

    protected abstract IProbabilityMassFunction getComparePMF(String var1, IProbabilityMassFunction var2);

    protected abstract IProbabilityMassFunction getComparePMF(String var1, String var2);

    public static IProbabilityMassFunction invertBoolPMF(IProbabilityMassFunction function) {
        List samples = function.getSamples();
        if (samples.size() == 2) {
            ISample sample1 = (ISample)samples.get(0);
            ISample sample2 = (ISample)samples.get(1);
            ISample sampleTrue = null;
            ISample sampleFalse = null;
            if (CompareOperation.sampleIsTrue(sample1)) {
                if (CompareOperation.sampleIsFalse(sample2)) {
                    sampleTrue = sample1;
                    sampleFalse = sample2;
                }
            } else if (CompareOperation.sampleIsFalse(sample1) && CompareOperation.sampleIsTrue(sample2)) {
                sampleTrue = sample2;
                sampleFalse = sample1;
            }
            if (sampleTrue != null && sampleFalse != null) {
                IProbabilityFunctionFactory probFac = ProbabilityFunctionFactoryImpl.eINSTANCE;
                IUnit unit = probFac.createUnit("bool");
                ArrayList<ISample> sampleList = new ArrayList<ISample>();
                ISample newTrueSample = probFac.createSample((Object)true, sampleFalse.getProbability());
                ISample newFalseSample = probFac.createSample((Object)false, sampleTrue.getProbability());
                sampleList.add(newTrueSample);
                sampleList.add(newFalseSample);
                IProbabilityMassFunction boolPMF = probFac.createProbabilityMassFunction(sampleList, unit, true);
                return boolPMF;
            }
        }
        throw new UnsupportedOperationException("Cannot invert PMF " + function.toString() + " as it is no valid BoolPMF.");
    }

    private static boolean sampleIsTrue(ISample sample) {
        if (sample.getValue() instanceof Boolean) {
            return (Boolean)sample.getValue();
        }
        return TRUE_STRING.equals(sample.getValue());
    }

    private static boolean sampleIsFalse(ISample sample) {
        if (sample.getValue() instanceof Boolean) {
            return (Boolean)sample.getValue() == false;
        }
        return FALSE_STRING.equals(sample.getValue());
    }
}

