/**
 */
package placementDescription.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import placementDescription.util.PlacementDescriptionAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class PlacementDescriptionItemProviderAdapterFactory extends PlacementDescriptionAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PlacementDescriptionItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link placementDescription.PlacementStrategy} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PlacementStrategyItemProvider placementStrategyItemProvider;

	/**
	 * This creates an adapter for a {@link placementDescription.PlacementStrategy}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPlacementStrategyAdapter() {
		if (placementStrategyItemProvider == null) {
			placementStrategyItemProvider = new PlacementStrategyItemProvider(this);
		}

		return placementStrategyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link placementDescription.ExternalCallPlacementStrategy} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExternalCallPlacementStrategyItemProvider externalCallPlacementStrategyItemProvider;

	/**
	 * This creates an adapter for a {@link placementDescription.ExternalCallPlacementStrategy}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExternalCallPlacementStrategyAdapter() {
		if (externalCallPlacementStrategyItemProvider == null) {
			externalCallPlacementStrategyItemProvider = new ExternalCallPlacementStrategyItemProvider(this);
		}

		return externalCallPlacementStrategyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link placementDescription.InternalActionPlacementStrategy} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InternalActionPlacementStrategyItemProvider internalActionPlacementStrategyItemProvider;

	/**
	 * This creates an adapter for a {@link placementDescription.InternalActionPlacementStrategy}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInternalActionPlacementStrategyAdapter() {
		if (internalActionPlacementStrategyItemProvider == null) {
			internalActionPlacementStrategyItemProvider = new InternalActionPlacementStrategyItemProvider(this);
		}

		return internalActionPlacementStrategyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link placementDescription.ControlFlowPlacementStrategy} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ControlFlowPlacementStrategyItemProvider controlFlowPlacementStrategyItemProvider;

	/**
	 * This creates an adapter for a {@link placementDescription.ControlFlowPlacementStrategy}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createControlFlowPlacementStrategyAdapter() {
		if (controlFlowPlacementStrategyItemProvider == null) {
			controlFlowPlacementStrategyItemProvider = new ControlFlowPlacementStrategyItemProvider(this);
		}

		return controlFlowPlacementStrategyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link placementDescription.PointCut} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PointCutItemProvider pointCutItemProvider;

	/**
	 * This creates an adapter for a {@link placementDescription.PointCut}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPointCutAdapter() {
		if (pointCutItemProvider == null) {
			pointCutItemProvider = new PointCutItemProvider(this);
		}

		return pointCutItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link placementDescription.Advice} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AdviceItemProvider adviceItemProvider;

	/**
	 * This creates an adapter for a {@link placementDescription.Advice}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAdviceAdapter() {
		if (adviceItemProvider == null) {
			adviceItemProvider = new AdviceItemProvider(this);
		}

		return adviceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link placementDescription.Import} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImportItemProvider importItemProvider;

	/**
	 * This creates an adapter for a {@link placementDescription.Import}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createImportAdapter() {
		if (importItemProvider == null) {
			importItemProvider = new ImportItemProvider(this);
		}

		return importItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link placementDescription.FeatureSelection} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FeatureSelectionItemProvider featureSelectionItemProvider;

	/**
	 * This creates an adapter for a {@link placementDescription.FeatureSelection}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFeatureSelectionAdapter() {
		if (featureSelectionItemProvider == null) {
			featureSelectionItemProvider = new FeatureSelectionItemProvider(this);
		}

		return featureSelectionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link placementDescription.FeatureList} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FeatureListItemProvider featureListItemProvider;

	/**
	 * This creates an adapter for a {@link placementDescription.FeatureList}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFeatureListAdapter() {
		if (featureListItemProvider == null) {
			featureListItemProvider = new FeatureListItemProvider(this);
		}

		return featureListItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link placementDescription.SelectedCV} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SelectedCVItemProvider selectedCVItemProvider;

	/**
	 * This creates an adapter for a {@link placementDescription.SelectedCV}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSelectedCVAdapter() {
		if (selectedCVItemProvider == null) {
			selectedCVItemProvider = new SelectedCVItemProvider(this);
		}

		return selectedCVItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (placementStrategyItemProvider != null) placementStrategyItemProvider.dispose();
		if (externalCallPlacementStrategyItemProvider != null) externalCallPlacementStrategyItemProvider.dispose();
		if (internalActionPlacementStrategyItemProvider != null) internalActionPlacementStrategyItemProvider.dispose();
		if (controlFlowPlacementStrategyItemProvider != null) controlFlowPlacementStrategyItemProvider.dispose();
		if (pointCutItemProvider != null) pointCutItemProvider.dispose();
		if (adviceItemProvider != null) adviceItemProvider.dispose();
		if (importItemProvider != null) importItemProvider.dispose();
		if (featureSelectionItemProvider != null) featureSelectionItemProvider.dispose();
		if (featureListItemProvider != null) featureListItemProvider.dispose();
		if (selectedCVItemProvider != null) selectedCVItemProvider.dispose();
	}

}
