/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.resources.active;

import de.uka.ipd.sdq.scheduler.IActiveResource;
import de.uka.ipd.sdq.scheduler.IRunningProcess;
import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.scheduler.entities.SchedulerEntity;
import de.uka.ipd.sdq.scheduler.sensors.IActiveResourceStateSensor;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.IResourceInstance;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.SimActiveResource;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.events.SchedulingEvent;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.events.SchedulingInterruptEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SimResourceInstance
extends SchedulerEntity
implements IResourceInstance {
    private static final Logger log = Logger.getLogger((String)SimResourceInstance.class.getCanonicalName());
    private final int number;
    private final IActiveResource containing_resource;
    private IRunningProcess running_process;
    private IRunningProcess last_running_process;
    private SchedulingEvent scheduling_event;
    private boolean isScheduling;
    private final List<IActiveResourceStateSensor> resourceObserverList = new ArrayList<IActiveResourceStateSensor>();

    public SimResourceInstance(SchedulerModel model, int number, IActiveResource containing_resource) {
        super(model, SimResourceInstance.class.getName());
        this.number = number;
        this.containing_resource = containing_resource;
        this.running_process = null;
        this.isScheduling = false;
    }

    @Override
    public IRunningProcess getRunningProcess() {
        return this.running_process;
    }

    @Override
    public void release() {
        this.last_running_process = this.running_process;
        this.running_process = null;
        this.updateObservers();
    }

    private void updateObservers() {
        for (IActiveResourceStateSensor observer : this.resourceObserverList) {
            observer.update((long)this.getQueueLength(), this.getId());
        }
    }

    @Override
    public void addObserver(IActiveResourceStateSensor observer) {
        this.resourceObserverList.add(observer);
    }

    @Override
    public void removeObserver(IActiveResourceStateSensor observer) {
        this.resourceObserverList.remove(observer);
    }

    @Override
    public boolean processAssigned() {
        return this.running_process != null;
    }

    @Override
    public void assign(IRunningProcess process) {
        assert (!this.processAssigned()) : "There is already a process executing on resource instance " + this;
        this.running_process = process;
        this.updateObservers();
    }

    @Override
    public String getName() {
        return String.valueOf(this.containing_resource.getName()) + "_" + this.number;
    }

    @Override
    public void scheduleSchedulingEvent(double time) {
        this.cancelSchedulingEvent();
        if (this.scheduling_event != null) {
            this.scheduling_event.schedule(this, time);
        } else {
            log.log((Priority)Level.ERROR, (Object)"Tried to reschedule event that did not exists. Error in simulation may cause subsequent failures.");
        }
    }

    @Override
    public void schedulingInterrupt(double time) {
        new SchedulingInterruptEvent(this.getModel(), (SimActiveResource)this.containing_resource).schedule(this, time);
    }

    @Override
    public void cancelSchedulingEvent() {
        if (this.scheduling_event != null) {
            this.scheduling_event.removeEvent();
        } else {
            log.log((Priority)Level.ERROR, (Object)"Tried to cancel event that did not exists. Error in simulation may cause subsequent failures.");
        }
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimResourceInstance) {
            SimResourceInstance instance = (SimResourceInstance)obj;
            return this.getId() == instance.getId();
        }
        return false;
    }

    public int getId() {
        return this.number;
    }

    public int hashCode() {
        return (String.valueOf(this.getName()) + this.getId()).hashCode();
    }

    @Override
    public double getNextSchedEventTime() {
        double simTime = this.getModel().getSimulationControl().getCurrentSimulationTime();
        double eventTime = this.scheduling_event.scheduledAtTime();
        return eventTime - simTime;
    }

    @Override
    public void start() {
        this.scheduling_event = new SchedulingEvent(this.getModel(), (SimActiveResource)this.containing_resource);
        this.scheduling_event.schedule(this, 0.0);
    }

    @Override
    public void stop() {
        if (this.scheduling_event != null) {
            this.scheduling_event.removeEvent();
        } else {
            log.log((Priority)Level.ERROR, (Object)"Tried to remove event that did not exists. Error in simulation may cause subsequent failures.");
        }
    }

    @Override
    public void setIsScheduling(boolean b) {
        this.isScheduling = b;
    }

    @Override
    public boolean isScheduling() {
        return this.isScheduling;
    }

    @Override
    public boolean isIdle() {
        return this.running_process == null;
    }

    @Override
    public IRunningProcess getLastRunningProcess() {
        return this.last_running_process;
    }

    public int getQueueLength() {
        return this.containing_resource.getQueueLengthFor((SchedulerEntity)this, 0);
    }
}

