/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.sensors.impl;

import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.scheduler.processes.PROCESS_STATE;
import de.uka.ipd.sdq.scheduler.sensors.IProcessStateSensor;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.IActiveProcess;

public class HptSensor
implements IProcessStateSensor {
    private SchedulerModel model;
    private PROCESS_STATE last_state;
    private double lastUpdateTime;
    private boolean isHpt = false;
    private double hpt = 0.0;
    private double threshold;
    private double hptStart;

    public HptSensor(SchedulerModel model, IActiveProcess process, double threshold) {
        this.model = model;
        this.lastUpdateTime = 0.0;
        this.last_state = process.getState();
        this.threshold = threshold;
    }

    public void start() {
        this.isHpt = true;
        this.hpt = 0.0;
        this.lastUpdateTime = this.hptStart = this.model.getSimulationControl().getCurrentSimulationTime();
    }

    public double getHpt() {
        return this.hpt;
    }

    public double getHptStart() {
        return this.hptStart;
    }

    public void stop() {
        double currentTime = this.model.getSimulationControl().getCurrentSimulationTime();
        double passedTime = currentTime - this.lastUpdateTime;
        if (this.last_state == PROCESS_STATE.RUNNING && this.isHpt) {
            this.hpt += passedTime;
        }
        this.lastUpdateTime = currentTime;
        this.isHpt = false;
    }

    public void update(PROCESS_STATE new_state) {
        if (this.isHpt) {
            double currentTime = this.model.getSimulationControl().getCurrentSimulationTime();
            double passedTime = currentTime - this.lastUpdateTime;
            if (this.last_state == PROCESS_STATE.RUNNING && new_state != PROCESS_STATE.RUNNING) {
                if (this.isHpt) {
                    this.hpt += passedTime;
                }
                this.lastUpdateTime = currentTime;
            }
            if (this.last_state != PROCESS_STATE.RUNNING && new_state == PROCESS_STATE.RUNNING) {
                if (passedTime > this.threshold) {
                    this.isHpt = false;
                }
                this.lastUpdateTime = currentTime;
            }
            this.last_state = new_state;
        }
    }
}

