/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.emfprofile.application.registry.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.registry.IProfileRegistry;

public class SelectProfileFilePage
extends WizardPage {
    private Collection<Profile> selectedProfiles = new ArrayList<Profile>();

    protected SelectProfileFilePage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setMessage("Select the EMF Profile to apply.");
        this.updatePageCompleteState();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        final ListViewer profileList = new ListViewer(container, 2820);
        profileList.getList().setLayoutData((Object)new GridData(1808));
        profileList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput instanceof Collection) {
                    for (Object element : (Collection)newInput) {
                        profileList.add(element);
                    }
                }
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return element instanceof Collection;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof Collection) {
                    return ((Collection)parentElement).toArray();
                }
                return null;
            }
        });
        profileList.getList().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)profileList.getSelection();
                SelectProfileFilePage.this.selectedProfiles.clear();
                for (Object next : selection) {
                    if (!(next instanceof Profile)) continue;
                    SelectProfileFilePage.this.selectedProfiles.add((Profile)next);
                }
                SelectProfileFilePage.this.updatePageCompleteState();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        profileList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Profile) {
                    Profile profile = (Profile)element;
                    return String.valueOf(profile.getName()) + " (" + profile.getNsURI() + ")";
                }
                return super.getText(element);
            }
        });
        profileList.setInput((Object)IProfileRegistry.eINSTANCE.getRegisteredProfiles());
        this.setControl((Control)container);
    }

    private void updatePageCompleteState() {
        if (this.getSelectedProfiles().size() < 1) {
            this.setErrorMessage("Select a profile to be applied.");
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    public Collection<Profile> getSelectedProfiles() {
        return this.selectedProfiles;
    }
}

