/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.quality.presentation;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.palladiosimulator.analyzer.quality.presentation.PrecisionGroup;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMRECategory;
import org.palladiosimulator.analyzer.quality.qualityannotation.PCMRERequestCategory;
import org.palladiosimulator.analyzer.quality.qualityannotation.Precision;
import org.palladiosimulator.analyzer.quality.qualityannotation.QualityAnnotationFactory;
import org.palladiosimulator.analyzer.quality.qualityannotation.REPrecision;
import swing2swt.layout.FlowLayout;

public class DefaultQualityWizardPage
extends WizardPage
implements Listener,
ModifyListener {
    private static final QualityAnnotationFactory qaFactory = QualityAnnotationFactory.eINSTANCE;
    private PrecisionGroup businessInterfaceCP;
    private PrecisionGroup businessInterfaceNoC;
    private PrecisionGroup infrastructureInterfaceCP;
    private PrecisionGroup infrastructureInterfaceNoC;
    private PrecisionGroup resourceInterfaceCP;
    private PrecisionGroup resourceInterfaceNoC;
    private PrecisionGroup resourceDemandNoC;
    private PrecisionGroup internalNoC;
    private PrecisionGroup internalCP;

    public DefaultQualityWizardPage(String pageName) {
        super(pageName);
        this.setMessage("Select the default precision for each category.");
    }

    public void createControl(Composite parent) {
        ScrolledComposite scl = new ScrolledComposite(parent, 768);
        this.setControl((Control)scl);
        Composite root = new Composite((Composite)scl, 512);
        scl.setContent((Control)root);
        root.setLayout((Layout)new FlowLayout(3, 5, 5));
        Group grpBI = new Group(root, 0);
        grpBI.setText("Business Interfaces");
        grpBI.setLayout((Layout)new RowLayout(256));
        this.businessInterfaceNoC = new PrecisionGroup("Number of Calls", this);
        this.businessInterfaceNoC.createGroup((Composite)grpBI);
        this.businessInterfaceCP = new PrecisionGroup("Call Parameters", this);
        this.businessInterfaceCP.createGroup((Composite)grpBI);
        Group grpII = new Group(root, 0);
        grpII.setText("Infrastructure Interfaces");
        grpII.setLayout((Layout)new RowLayout(256));
        this.infrastructureInterfaceNoC = new PrecisionGroup("Number of Calls", this);
        this.infrastructureInterfaceNoC.createGroup((Composite)grpII);
        this.infrastructureInterfaceCP = new PrecisionGroup("Call Parameters", this);
        this.infrastructureInterfaceCP.createGroup((Composite)grpII);
        Group grpRI = new Group(root, 0);
        grpRI.setText("Resource Interfaces");
        grpRI.setLayout((Layout)new RowLayout(256));
        this.resourceInterfaceNoC = new PrecisionGroup("Number of Calls", this);
        this.resourceInterfaceNoC.createGroup((Composite)grpRI);
        this.resourceInterfaceCP = new PrecisionGroup("Call Parameters", this);
        this.resourceInterfaceCP.createGroup((Composite)grpRI);
        Group grpRD = new Group(root, 0);
        grpRD.setText("Resource Demands");
        grpRD.setLayout((Layout)new RowLayout(256));
        this.resourceDemandNoC = new PrecisionGroup("Number of Calls", this);
        this.resourceDemandNoC.createGroup((Composite)grpRD);
        Group grpI = new Group(root, 0);
        grpI.setText("Internal");
        grpI.setLayout((Layout)new RowLayout(256));
        this.internalNoC = new PrecisionGroup("Number of Calls", this);
        this.internalNoC.createGroup((Composite)grpI);
        this.internalCP = new PrecisionGroup("Call Parameters", this);
        this.internalCP.createGroup((Composite)grpI);
        root.setSize(root.computeSize(-1, -1));
    }

    public String getErrorMessage() {
        if (this.businessInterfaceCP.getErrorMessage() != null) {
            return this.businessInterfaceCP.getErrorMessage();
        }
        if (this.businessInterfaceNoC.getErrorMessage() != null) {
            return this.businessInterfaceNoC.getErrorMessage();
        }
        if (this.infrastructureInterfaceCP.getErrorMessage() != null) {
            return this.infrastructureInterfaceCP.getErrorMessage();
        }
        if (this.infrastructureInterfaceNoC.getErrorMessage() != null) {
            return this.infrastructureInterfaceNoC.getErrorMessage();
        }
        if (this.resourceInterfaceCP.getErrorMessage() != null) {
            return this.resourceInterfaceCP.getErrorMessage();
        }
        if (this.resourceInterfaceNoC.getErrorMessage() != null) {
            return this.resourceInterfaceNoC.getErrorMessage();
        }
        if (this.resourceDemandNoC.getErrorMessage() != null) {
            return this.resourceDemandNoC.getErrorMessage();
        }
        if (this.internalCP.getErrorMessage() != null) {
            return this.internalCP.getErrorMessage();
        }
        if (this.internalNoC.getErrorMessage() != null) {
            return this.internalNoC.getErrorMessage();
        }
        return null;
    }

    public boolean isPageComplete() {
        return this.businessInterfaceNoC.isValid() & this.businessInterfaceCP.isValid() & this.infrastructureInterfaceNoC.isValid() & this.infrastructureInterfaceCP.isValid() & this.resourceInterfaceNoC.isValid() & this.resourceInterfaceCP.isValid() & this.resourceDemandNoC.isValid();
    }

    public void dispose() {
        this.businessInterfaceNoC.dispose();
        this.businessInterfaceCP.dispose();
        this.infrastructureInterfaceNoC.dispose();
        this.infrastructureInterfaceCP.dispose();
        this.resourceInterfaceNoC.dispose();
        this.resourceInterfaceCP.dispose();
        this.resourceDemandNoC.dispose();
        this.internalNoC.dispose();
        this.internalCP.dispose();
        super.dispose();
    }

    public PCMRECategory getRequiredElement(PCMRERequestCategory category) {
        PCMRECategory result = qaFactory.createPCMRECategory();
        result.setCategory(category);
        REPrecision precision = qaFactory.createREPrecision();
        result.setPrecision(precision);
        switch (category) {
            case COMPONENT_INTERNAL: {
                precision.setDefaultPrecisionNumberOfCalls(this.internalNoC.getPrecision());
                precision.setDefaultPrecisionCallParameter(this.internalCP.getPrecision());
                break;
            }
            case COMPONENT: {
                precision.setDefaultPrecisionNumberOfCalls(this.businessInterfaceNoC.getPrecision());
                precision.setDefaultPrecisionCallParameter(this.businessInterfaceCP.getPrecision());
                break;
            }
            case INFRASTRUCTURE: {
                precision.setDefaultPrecisionNumberOfCalls(this.infrastructureInterfaceNoC.getPrecision());
                precision.setDefaultPrecisionCallParameter(this.infrastructureInterfaceCP.getPrecision());
                break;
            }
            case RESOURCE: {
                precision.setDefaultPrecisionNumberOfCalls(this.resourceInterfaceNoC.getPrecision());
                precision.setDefaultPrecisionCallParameter(this.resourceInterfaceCP.getPrecision());
                break;
            }
            case RESOURCE_DEMAND: {
                precision.setDefaultPrecisionNumberOfCalls(this.resourceDemandNoC.getPrecision());
                precision.setDefaultPrecisionCallParameter((Precision)qaFactory.createNoPrecision());
                break;
            }
            default: {
                throw new IllegalStateException("Category type unknown.");
            }
        }
        return result;
    }

    protected void validate() {
        String errorMessage = this.getErrorMessage();
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    public void handleEvent(Event event) {
        this.validate();
    }

    public void modifyText(ModifyEvent e) {
        this.validate();
    }
}

