/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.quality.presentation;

import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.analyzer.workflow.core.ConstantsContainer;

public class SelectRepositoryWizardPage
extends WizardPage
implements ModifyListener {
    private String DEFAULT_REPOSITORY_URI = "";
    protected Text txtRepository;
    protected IStructuredSelection selection;

    public SelectRepositoryWizardPage(String pageName) {
        super(pageName);
        this.setMessage("Select the repository for which the defaults should be created.");
    }

    public void init(IStructuredSelection selection) {
        this.selection = selection;
    }

    public String getRepositoryFileUri() {
        return this.txtRepository.getText();
    }

    public void createControl(Composite parent) {
        String portableString;
        String target;
        IResource selectedResource;
        Object selectedElement;
        Composite root = new Composite(parent, 0);
        this.setControl((Control)root);
        root.setLayout((Layout)new GridLayout());
        this.txtRepository = new Text(root, 2048);
        this.txtRepository.setText(this.DEFAULT_REPOSITORY_URI);
        TabHelper.createFileInputSection((Composite)root, (ModifyListener)this, (String)"Repository", (String[])ConstantsContainer.REPOSITORY_EXTENSION, (Text)this.txtRepository, (String)"Select Repository file", (Shell)this.getShell(), (String)this.DEFAULT_REPOSITORY_URI);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource && (selectedResource = (IResource)selectedElement).getType() == 1 && (target = "platform:/resource" + (portableString = selectedResource.getFullPath().toOSString())).endsWith(".repository")) {
            this.txtRepository.setText(target);
        }
        this.validate();
    }

    protected void validate() {
        if (this.txtRepository.getText().equals(this.DEFAULT_REPOSITORY_URI)) {
            this.setErrorMessage("Select a repository file.");
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    public void modifyText(ModifyEvent e) {
        this.validate();
    }
}

