/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.repository.local.dao;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.palladiosimulator.edp2.dao.EmfResourceDao;
import org.palladiosimulator.edp2.dao.exception.DataNotAccessibleException;
import org.palladiosimulator.edp2.impl.resource.EmfModelXMIResourceFactoryImpl;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentDataFactory;
import org.palladiosimulator.edp2.models.ExperimentData.impl.ExperimentDataPackageImpl;
import org.palladiosimulator.edp2.repository.local.dao.FileAccessDao;
import org.palladiosimulator.edp2.repository.local.dao.internal.visitors.EmfmodelExtensionSwitch;

abstract class EmfFileAccessDao
extends FileAccessDao
implements EmfResourceDao {
    private static final Logger LOGGER = Logger.getLogger(EmfFileAccessDao.class.getCanonicalName());
    protected static final ExperimentDataFactory ModelFactory = ExperimentDataFactory.eINSTANCE;
    protected ResourceSet resourceSet = null;
    protected Resource resource = null;
    protected EObject emfRootElement;

    public synchronized void close() throws DataNotAccessibleException {
        super.close();
        try {
            this.resource.save(Collections.EMPTY_MAP);
            this.setClosed();
            this.emfRootElement = null;
            this.resource.unload();
        }
        catch (IOException e) {
            String errorMsg = "Could not close file " + this.resourceFile.getAbsolutePath() + " and save the contained EMF model.";
            LOGGER.log(Level.SEVERE, errorMsg);
            throw new DataNotAccessibleException(errorMsg, (Throwable)e);
        }
    }

    @Override
    public synchronized void delete() throws DataNotAccessibleException {
        super.delete();
        try {
            this.emfRootElement = null;
            if (this.resource != null) {
                this.resource.delete(null);
            }
            this.setDeleted(true);
        }
        catch (IOException e) {
            this.setDeleted(false);
            String errorMsg = "Could not delete file " + this.resourceFile.getAbsolutePath() + " and its contained EMF model.";
            LOGGER.log(Level.WARNING, errorMsg);
            throw new DataNotAccessibleException(errorMsg, (Throwable)e);
        }
    }

    public synchronized void open() throws DataNotAccessibleException {
        super.open();
        String filename = this.resourceFile.getAbsolutePath();
        URI uri = URI.createFileURI((String)filename);
        try {
            if (this.resource == null) {
                this.resource = this.resourceSet.createResource(uri);
            }
            if (new File(this.resource.getURI().toFileString()).isFile()) {
                try {
                    this.resource.load(null);
                }
                catch (IOException ie) {
                    LOGGER.log(Level.WARNING, "Could not load EMF model from resource at " + filename + ". " + ie.getMessage());
                }
            }
            if (this.resource.getContents().size() == 0) {
                this.resource.getContents().add((Object)this.createEmfRootElement());
            }
            if (this.resource.getContents().size() == 1) {
                String extension = (String)new EmfmodelExtensionSwitch().doSwitch((EObject)this.resource.getContents().get(0));
                if (extension == null) {
                    String msg = "The root element in the file is not valid to EDP2 specifications. Filename = " + filename;
                    LOGGER.log(Level.WARNING, msg);
                    this.emfRootElement = null;
                    this.setClosed();
                    throw new DataNotAccessibleException(msg, null);
                }
                if (!this.resourceFile.getName().endsWith(extension)) {
                    String msg = "The root element in the file is not valid to EDP2 specifications.  Expected root element = " + extension + ". Filename = " + filename;
                    LOGGER.log(Level.WARNING, msg);
                    this.emfRootElement = null;
                    this.setClosed();
                    throw new DataNotAccessibleException(msg, null);
                }
            } else {
                String msg = "Only one root element is allowed per file in EDP2 specifications. Filename = " + filename;
                LOGGER.log(Level.WARNING, msg);
                this.emfRootElement = null;
                this.setClosed();
                throw new DataNotAccessibleException(msg, null);
            }
            this.emfRootElement = (EObject)this.resource.getContents().get(0);
            this.setOpen();
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.emfRootElement = null;
            this.setClosed();
            String errorMsg = "Could not load EMF model from file " + filename + ".";
            LOGGER.log(Level.SEVERE, errorMsg);
            throw new DataNotAccessibleException(errorMsg, (Throwable)ioobe);
        }
    }

    protected abstract EObject createEmfRootElement();

    protected EObject getEmfRootElement() {
        return this.emfRootElement;
    }

    public synchronized void setResourceSet(ResourceSet newResourceSet) {
        if (this.resourceSet != null) {
            String msg = "Resource set must only be registered once.";
            LOGGER.log(Level.SEVERE, msg);
            throw new IllegalStateException(msg);
        }
        this.resourceSet = newResourceSet;
        EmfModelXMIResourceFactoryImpl resourceFactoryImpl = new EmfModelXMIResourceFactoryImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("edp2", resourceFactoryImpl);
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("edp2desc", resourceFactoryImpl);
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("edp2nm", resourceFactoryImpl);
        ExperimentDataPackageImpl.eINSTANCE.eClass();
    }

    public synchronized ResourceSet getResourceSet() {
        return this.resourceSet;
    }
}

