/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.visualization.jfreechart.input.histogram;

import java.awt.Color;
import java.awt.Paint;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.measure.Measure;
import org.eclipse.ui.IMemento;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardXYItemLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.TextAnchor;
import org.palladiosimulator.edp2.datastream.AbstractDataSource;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.edp2.datastream.configurable.PropertyConfigurable;
import org.palladiosimulator.edp2.visualization.jfreechart.input.AbstractXYVisualizationInput;
import org.palladiosimulator.edp2.visualization.jfreechart.input.JFreeChartVisualizationSingleDatastreamInput;
import org.palladiosimulator.edp2.visualization.jfreechart.input.histogram.HistogramVisualizationInputConfiguration;
import org.palladiosimulator.edp2.visualization.jfreechart.input.histogram.HistogramVisualizationInputFactory;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;

public class HistogramVisualizationInput
extends AbstractXYVisualizationInput {
    public HistogramVisualizationInput() {
        this((AbstractDataSource)null);
    }

    public HistogramVisualizationInput(AbstractDataSource source) {
    }

    public String getFactoryId() {
        return HistogramVisualizationInputFactory.FACTORY_ID;
    }

    @Override
    public void saveState(IMemento memento) {
        HistogramVisualizationInputFactory.saveState(memento, this);
    }

    @Override
    protected Plot generatePlot(PropertyConfigurable config, AbstractDataset dataset) {
        HistogramVisualizationInputConfiguration configuration = (HistogramVisualizationInputConfiguration)config;
        XYPlot plot = new XYPlot();
        XYBarRenderer renderer = new XYBarRenderer();
        renderer.setShadowVisible(false);
        renderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        NumberAxis domainAxis = new NumberAxis(configuration.isShowDomainAxisLabel() ? configuration.getDomainAxisLabel() : null);
        domainAxis.setAutoRangeIncludesZero(configuration.isIncludeZero());
        NumberAxis rangeAxis = new NumberAxis(configuration.isShowRangeAxisLabel() ? configuration.getRangeAxisLabel() : null);
        plot.setDataset((XYDataset)dataset);
        plot.setRenderer((XYItemRenderer)renderer);
        plot.setRangeAxis((ValueAxis)rangeAxis);
        plot.setDomainAxis((ValueAxis)domainAxis);
        this.configureSeriesColors((AbstractRenderer)renderer);
        ((HistogramDataset)dataset).setType(configuration.isAbsoluteFrequency() ? HistogramType.FREQUENCY : HistogramType.RELATIVE_FREQUENCY);
        renderer.setMargin(configuration.getBarMargin() / 100.0);
        renderer.setBaseItemLabelGenerator((XYItemLabelGenerator)new StandardXYItemLabelGenerator());
        renderer.setBaseItemLabelPaint((Paint)Color.BLACK);
        renderer.setBasePositiveItemLabelPosition(new ItemLabelPosition());
        renderer.setBaseNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.TOP_CENTER));
        renderer.setBaseItemLabelsVisible(configuration.isShowItemValues());
        return plot;
    }

    @Override
    protected AbstractDataset generateDataset() {
        HistogramDataset result = new HistogramDataset();
        int i = 0;
        while (i < this.getInputs().size()) {
            result.addSeries((Comparable)((Object)((JFreeChartVisualizationSingleDatastreamInput)((Object)this.getInputs().get(i))).getInputName()), this.generateData(((JFreeChartVisualizationSingleDatastreamInput)((Object)this.getInputs().get(i))).getDataSource()), ((HistogramVisualizationInputConfiguration)this.getConfiguration()).getNumberOfBins());
            ++i;
        }
        return result;
    }

    private double[] generateData(IDataSource dataSource) {
        IDataStream inputStream = dataSource.getDataStream();
        double[] data = new double[inputStream.size()];
        HistogramVisualizationInputConfiguration configuration = (HistogramVisualizationInputConfiguration)this.getConfiguration();
        int i = 0;
        for (TupleMeasurement tuple : inputStream) {
            Measure measure = tuple.asArray()[this.getYPos()];
            data[i] = measure.doubleValue(configuration.getUnit());
            ++i;
        }
        return data;
    }

    @Override
    protected PropertyConfigurable createConfiguration() {
        return new HistogramVisualizationInputConfiguration();
    }

    @Override
    protected void firstChildInputAdded(JFreeChartVisualizationSingleDatastreamInput newChildInput) {
        super.firstChildInputAdded(newChildInput);
        HashMap<String, Object> properties = new HashMap<String, Object>(this.getProperties());
        MetricSetDescription metricSet = (MetricSetDescription)newChildInput.getDataSource().getMetricDesciption();
        NumericalBaseMetricDescription baseMetric = (NumericalBaseMetricDescription)metricSet.getSubsumedMetrics().get(this.getYPos());
        properties.put("unit", baseMetric.getDefaultUnit());
        properties.put("domainAxisLabel", this.getAxisDefaultLabel(this.getYPos()));
        properties.put("rangeAxisLabel", "Frequency [%]");
        this.setProperties(properties);
    }

    protected Set<String> getPropertyKeysTriggeringUpdate() {
        return new HashSet<String>(Arrays.asList("numberOfBins", "unit"));
    }
}

