/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.abstractsimulation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ExportOption implements Enumerator
{
    EDP2(0, "EDP2", "EDP2"),
    CSV(1, "CSV", "CSV");

    public static final String copyright = "Palladiosimulator.org 2008-2017";
    public static final int EDP2_VALUE = 0;
    public static final int CSV_VALUE = 1;
    private static final ExportOption[] VALUES_ARRAY;
    public static final List<ExportOption> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ExportOption[]{EDP2, CSV};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ExportOption get(String literal) {
        ExportOption[] exportOptionArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            ExportOption result = exportOptionArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static ExportOption getByName(String name) {
        ExportOption[] exportOptionArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            ExportOption result = exportOptionArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static ExportOption get(int value) {
        switch (value) {
            case 0: {
                return EDP2;
            }
            case 1: {
                return CSV;
            }
        }
        return null;
    }

    private ExportOption(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

