/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.system.structure.connector.event;

import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.exceptions.NoSuchElementException;
import org.palladiosimulator.generator.fluent.system.structure.connector.IContextRoleCombinator;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.SourceRole;

public class SourceRoleSelector<T> {
    private final IContextRoleCombinator<SourceRole, T> combinator;
    private final AssemblyContext context;

    public SourceRoleSelector(IContextRoleCombinator<SourceRole, T> combinator, AssemblyContext context) {
        this.combinator = combinator;
        this.context = context;
    }

    public T withSourceRole(SourceRole role) {
        IllegalArgumentException.throwIfNull(role, "The given Role must not be null.");
        return this.combinator.combineContextAndRole(this.context, role);
    }

    public T withSourceRole(String name) throws NoSuchElementException {
        RequiredRole role = this.context.getEncapsulatedComponent__AssemblyContext().getRequiredRoles_InterfaceRequiringEntity().stream().filter(x -> x.getEntityName().equals(name)).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("No SourceRole with name '%s' found.", name)));
        try {
            return this.withSourceRole((SourceRole)role);
        }
        catch (ClassCastException e) {
            throw new NoSuchElementException(String.format("A Role with name '%s' was found, but it was not a SourceRole. Please make sure all names are unique.%n%s", name), e);
        }
    }
}

