/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.generator.fluent.usagemodel.structure.components.actions;

import java.util.ArrayList;
import java.util.List;
import org.palladiosimulator.generator.fluent.exceptions.IllegalArgumentException;
import org.palladiosimulator.generator.fluent.shared.components.VariableUsageCreator;
import org.palladiosimulator.generator.fluent.usagemodel.structure.components.actions.ActionCreator;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.UsagemodelFactory;

public class EntryLevelSystemCallCreator
extends ActionCreator {
    private final List<VariableUsage> outputParameterUsage = new ArrayList<VariableUsage>();
    private final List<VariableUsage> inputParameterUsage = new ArrayList<VariableUsage>();
    private int priority = 0;
    private OperationSignature opSignature;
    private OperationProvidedRole opRole;

    public EntryLevelSystemCallCreator(OperationSignature operationSignature, OperationProvidedRole operationProvidedRole) {
        this.withOperationSignatureEntryLevelSystemCall(operationSignature);
        this.withProvidedRoleEntryLevelSystemCall(operationProvidedRole);
    }

    private EntryLevelSystemCallCreator withOperationSignatureEntryLevelSystemCall(OperationSignature operationSignature) {
        IllegalArgumentException.throwIfNull(operationSignature, "The given Operation Signature must not be null");
        this.opSignature = operationSignature;
        return this;
    }

    private EntryLevelSystemCallCreator withProvidedRoleEntryLevelSystemCall(OperationProvidedRole operationProvidedRole) {
        IllegalArgumentException.throwIfNull(operationProvidedRole, "The given Provided Role must not be null");
        this.opRole = operationProvidedRole;
        return this;
    }

    public EntryLevelSystemCallCreator withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public EntryLevelSystemCallCreator addToEntryLevelSystemCallOutput(VariableUsageCreator outputParameterUsage) {
        IllegalArgumentException.throwIfNull(outputParameterUsage, "The given Output Variable Usage must not be null");
        this.outputParameterUsage.add(outputParameterUsage.build());
        return this;
    }

    public EntryLevelSystemCallCreator addToEntryLevelSystemCallInput(VariableUsageCreator inputParameterUsage) {
        IllegalArgumentException.throwIfNull(inputParameterUsage, "The given Input Variable Usage must not be null");
        this.inputParameterUsage.add(inputParameterUsage.build());
        return this;
    }

    public EntryLevelSystemCall build() {
        EntryLevelSystemCall call = UsagemodelFactory.eINSTANCE.createEntryLevelSystemCall();
        call.getOutputParameterUsages_EntryLevelSystemCall().addAll(this.outputParameterUsage);
        call.getInputParameterUsages_EntryLevelSystemCall().addAll(this.inputParameterUsage);
        if (this.opSignature != null) {
            call.setOperationSignature__EntryLevelSystemCall(this.opSignature);
        }
        if (this.opRole != null) {
            call.setProvidedRole_EntryLevelSystemCall(this.opRole);
        }
        call.setPriority(this.priority);
        if (this.name != null) {
            call.setEntityName(this.name);
        }
        if (this.successor != null) {
            call.setSuccessor(this.successor);
        }
        return call;
    }

    @Override
    public EntryLevelSystemCallCreator withSuccessor(ActionCreator action) {
        return (EntryLevelSystemCallCreator)super.withSuccessor(action);
    }

    @Override
    public EntryLevelSystemCallCreator withName(String name) {
        return (EntryLevelSystemCallCreator)super.withName(name);
    }
}

