/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.wizardmodel;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EnumMap;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.palladiosimulator.measurementsui.datamanipulation.ResourceEditorImpl;
import org.palladiosimulator.measurementsui.datamanipulation.SloEditor;
import org.palladiosimulator.measurementsui.dataprovider.DataApplication;
import org.palladiosimulator.measurementsui.dataprovider.SloProvider;
import org.palladiosimulator.measurementsui.wizardmodel.SloWizardModelType;
import org.palladiosimulator.measurementsui.wizardmodel.WizardModelSlo;
import org.palladiosimulator.measurementsui.wizardmodel.pages.SloCreationWizardModel;
import org.palladiosimulator.measurementsui.wizardmodel.pages.SloMeasurementSpecSelectionWizardModel;
import org.palladiosimulator.measurementsui.wizardmodel.pages.SloThresholdWizardModel;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjective;

public class SloWizardModelManager {
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private SloProvider sloProvider = SloProvider.getInstance();
    private SloEditor sloEditor = new SloEditor();
    private ResourceEditorImpl editor;
    private DataApplication dataApp;
    private boolean isEditing;
    private WizardModelSlo newWizardModel;
    private EnumMap<SloWizardModelType, WizardModelSlo> wizardModels = new EnumMap(SloWizardModelType.class);

    public SloWizardModelManager(boolean isNewSlo, ServiceLevelObjective slo) {
        boolean bl = this.isEditing = !isNewSlo;
        if (isNewSlo) {
            ServiceLevelObjective serviceLevelObjective = this.sloEditor.createServiceLevelObjective("", "", null, null, null);
            this.sloProvider.setServiceLevelObjective(serviceLevelObjective);
            this.sloProvider.setName("");
            this.sloProvider.setDescription("");
        } else {
            this.sloProvider.setServiceLevelObjective(slo);
            this.sloProvider.setMeasurementSpecification(slo.getMeasurementSpecification());
            this.sloProvider.setLowerThreshold(slo.getLowerThreshold());
            this.sloProvider.setUpperThreshols(slo.getUpperThreshold());
            this.sloProvider.setName(slo.getName());
            this.sloProvider.setDescription(slo.getDescription());
        }
        this.dataApp = DataApplication.getInstance();
        this.editor = ResourceEditorImpl.getInstance();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void cancel() {
        if (this.isEditing) {
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.sloProvider.getServiceLevelObjective());
            CommandStack commandStack = editingDomain.getCommandStack();
            while (commandStack.canUndo()) {
                editingDomain.getCommandStack().undo();
            }
        }
    }

    public void finish() {
        ServiceLevelObjective serviceLevelObjective = this.sloProvider.getServiceLevelObjective();
        if (this.isEditing) {
            this.sloEditor.setSLOName(serviceLevelObjective, this.sloProvider.getName());
            this.sloEditor.setSLODescription(serviceLevelObjective, this.sloProvider.getDescription());
            this.sloEditor.setMeasurementSpecification(serviceLevelObjective, this.sloProvider.getMeasurementSpecification());
        } else {
            serviceLevelObjective.setName(this.sloProvider.getName());
            serviceLevelObjective.setDescription(this.sloProvider.getDescription());
            serviceLevelObjective.setMeasurementSpecification(this.sloProvider.getMeasurementSpecification());
            this.editor.addServiceLevelObjectiveToRepository((EObject)this.dataApp.getSLORepository(), (EObject)serviceLevelObjective);
        }
        this.changes.firePropertyChange("save", 1, 2);
    }

    public boolean canFinish() {
        return this.getWizardModel(SloWizardModelType.SLO_CREATION).canFinish() && this.getWizardModel(SloWizardModelType.SLO_MEASUREMENT_SPEC).canFinish() && this.getWizardModel(SloWizardModelType.SLO_THRESHOLDING).canFinish();
    }

    public WizardModelSlo getWizardModel(SloWizardModelType sloWizardModelType) {
        if (this.wizardModels.containsKey((Object)sloWizardModelType)) {
            return this.wizardModels.get((Object)sloWizardModelType);
        }
        switch (sloWizardModelType) {
            case SLO_CREATION: {
                this.newWizardModel = new SloCreationWizardModel(this.sloProvider, this.isEditing);
                break;
            }
            case SLO_MEASUREMENT_SPEC: {
                this.newWizardModel = new SloMeasurementSpecSelectionWizardModel(this.sloProvider, this.isEditing);
                break;
            }
            case SLO_THRESHOLDING: {
                this.newWizardModel = new SloThresholdWizardModel(this.sloProvider, this.isEditing);
                break;
            }
            case SLO_EDITING: {
                this.newWizardModel = new SloCreationWizardModel(this.sloProvider, this.isEditing);
            }
            default: {
                return null;
            }
        }
        this.wizardModels.put(sloWizardModelType, this.newWizardModel);
        return this.newWizardModel;
    }
}

