/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.wizardmodel.pages;

import java.util.List;
import org.palladiosimulator.measurementsui.dataprovider.ProcessingTypeProvider;
import org.palladiosimulator.measurementsui.wizardmodel.WizardModel;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.Monitor;
import org.palladiosimulator.monitorrepository.ProcessingType;

public class ProcessingTypeSelectionWizardModel
implements WizardModel {
    private static final String INFORMATION_MESSAGE = "Please select a Processing Type for each Metric Description.\nA Processing Type defines how the measurements are computed during a simulation. Choose a different type than FeedThrough, if the measurements should be aggregated for the simulation results.";
    private static final String PROCESSING_TYPE_TITLE = "Select Processing Types";
    private Monitor usedMetricsMonitor;
    private boolean isEditing;
    private ProcessingTypeProvider provider;

    public ProcessingTypeSelectionWizardModel(Monitor monitor, boolean isEditing) {
        this.usedMetricsMonitor = monitor;
        this.isEditing = isEditing;
        this.provider = new ProcessingTypeProvider();
    }

    public Monitor getUsedMetricsMonitor() {
        return this.usedMetricsMonitor;
    }

    @Override
    public boolean canFinish() {
        return true;
    }

    @Override
    public String getInfoText() {
        return INFORMATION_MESSAGE;
    }

    @Override
    public String getTitleText() {
        return PROCESSING_TYPE_TITLE;
    }

    public String[] providePossibleProcessingTypes() {
        return this.provider.provideBasicProcessingTypes();
    }

    public void assignProcessingType(MeasurementSpecification aMeasurementSpecification, String selectedProcessingType) {
        this.provider.assignProcessingTypeToMeasurementSpecification(aMeasurementSpecification, selectedProcessingType, this.isEditing);
    }

    public List<String> fieldsForThisProcessingType(String processingTypeString) {
        return this.provider.provideProcessingTypeProperties(processingTypeString);
    }

    public void editAProcessingTypeAttribute(MeasurementSpecification aMeasurementSpecification, String aProcessingTypeAttribute, double value) {
        this.provider.setAProcessingTypeAttribute(aMeasurementSpecification, aProcessingTypeAttribute, value, this.isEditing);
    }

    public Number getAProccesingTypeAttribute(MeasurementSpecification aMeasurementSpecification, String aProcessingTypeAttribute) {
        return this.provider.getAProcessingType(aMeasurementSpecification, aProcessingTypeAttribute);
    }

    public String getStringOfProcessingType(ProcessingType processingType) {
        return this.provider.getProcessingTypeString(processingType);
    }
}

