/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.wizardmodel.pages;

import org.palladiosimulator.measurementsui.dataprovider.SloProvider;
import org.palladiosimulator.measurementsui.wizardmodel.WizardModelSlo;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjective;

public class SloCreationWizardModel
implements WizardModelSlo {
    private static final String CREATE_SLO_INFO_TEXT = "A Service Level Objective is used for specifying the goals the measurements should achieve.\n\nYou can set a name and a description for your Service Level Objective here.";
    private static final String CREATE_SLO_TITEL = "Create Service Level Objective";
    private static final String EDIT_SLO_TITEL = "Edit Service Level Objective";
    private SloProvider sloProvider = SloProvider.getInstance();
    private boolean isEditing;

    public SloCreationWizardModel(SloProvider dataprovider, boolean isEditing) {
        this.isEditing = isEditing;
        this.sloProvider = dataprovider;
    }

    public ServiceLevelObjective getSlo() {
        return this.sloProvider.getServiceLevelObjective();
    }

    public void setServiceLevelObjective(ServiceLevelObjective slo) {
        this.sloProvider.setServiceLevelObjective(slo);
    }

    public void setName(String name) {
        this.sloProvider.setName(name);
    }

    public void setDescription(String description) {
        this.sloProvider.setDescription(description);
    }

    @Override
    public boolean canFinish() {
        boolean canFinish;
        try {
            canFinish = !this.sloProvider.getName().isEmpty();
        }
        catch (Exception exception) {
            canFinish = false;
        }
        return canFinish;
    }

    public String getName() {
        return this.sloProvider.getName();
    }

    public String getDescription() {
        return this.sloProvider.getDescription();
    }

    @Override
    public String getInfoText() {
        return CREATE_SLO_INFO_TEXT;
    }

    @Override
    public String getTitleText() {
        if (this.isEditing) {
            return EDIT_SLO_TITEL;
        }
        return CREATE_SLO_TITEL;
    }
}

