/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.measurementsui.wizard.handlers.editingsupport;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.palladiosimulator.measurementsui.wizard.handlers.editingsupport.ProcessingTypeSelectionEditingSupport;
import org.palladiosimulator.measurementsui.wizardmodel.pages.ProcessingTypeSelectionWizardModel;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;

public final class ProcessingTypeDropDownEditingSupport
extends ProcessingTypeSelectionEditingSupport {
    public ProcessingTypeDropDownEditingSupport(ColumnViewer columnViewer, TableViewer tableViewer, ProcessingTypeSelectionWizardModel processingTypeSelectionWizardModel) {
        super(columnViewer, tableViewer, processingTypeSelectionWizardModel);
        this.cellEditor = new ComboBoxViewerCellEditor((Composite)this.getViewer().getControl(), 8);
        ((ComboBoxViewerCellEditor)this.cellEditor).setContenProvider((IStructuredContentProvider)new ArrayContentProvider());
        String[] possibleProcessingTypes = processingTypeSelectionWizardModel.providePossibleProcessingTypes();
        ((ComboBoxViewerCellEditor)this.cellEditor).setInput((Object)possibleProcessingTypes);
        this.enableTableRowUpdateOnValueChange();
    }

    private void enableTableRowUpdateOnValueChange() {
        final CCombo comboBox = (CCombo)this.cellEditor.getControl();
        comboBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                comboBox.setEnabled(false);
                comboBox.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        MeasurementSpecification measurementSpecification = (MeasurementSpecification)element;
        return this.processingTypeSelectionWizardModel.getStringOfProcessingType(measurementSpecification.getProcessingType());
    }

    protected void setValue(Object element, Object value) {
        MeasurementSpecification measurementSpecification = (MeasurementSpecification)element;
        String selectedProcessingTypeString = (String)value;
        this.processingTypeSelectionWizardModel.assignProcessingType(measurementSpecification, selectedProcessingTypeString);
        this.tableViewer.refresh();
    }
}

