/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.metricspec.metricentity;

import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.metricentity.IMetricEntity;

public class MetricEntity
implements IMetricEntity {
    private MetricDescription metricDesciption;
    private boolean isInitialised = false;

    protected MetricEntity() {
    }

    public MetricEntity(MetricDescription metricDesciption) {
        this.setMetricDescription(metricDesciption);
    }

    protected void setMetricDescription(MetricDescription metricDesciption) {
        if (this.isInitialised) {
            throw new IllegalStateException("Metric description of metric entity cannot be changed after initalisation");
        }
        if (metricDesciption == null) {
            throw new IllegalArgumentException("Metric description has to be a valid instance.");
        }
        this.checkValidString(metricDesciption.getName());
        this.checkValidString(metricDesciption.getTextualDescription());
        this.checkValidString(metricDesciption.getId());
        this.metricDesciption = metricDesciption;
        this.isInitialised = true;
    }

    @Override
    public MetricDescription getMetricDesciption() {
        this.checkInitialised();
        return this.metricDesciption;
    }

    private void checkInitialised() {
        if (!this.isInitialised) {
            throw new IllegalStateException("Metric description is not initialised");
        }
    }

    @Override
    public final boolean isCompatibleWith(MetricDescription other) {
        this.checkInitialised();
        return this.getMetricDesciption() == other || this.metricDesciption.getId().equals(other.getId());
    }

    private void checkValidString(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Parameter must not be null or empty");
        }
    }
}

