/**
 */
package org.palladiosimulator.monitorrepository.util;

import de.uka.ipd.sdq.identifier.Identifier;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

import org.palladiosimulator.monitorrepository.*;

import org.palladiosimulator.pcm.PCMBaseClass;
import org.palladiosimulator.pcm.PCMClass;

import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.core.entity.NamedElement;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.palladiosimulator.monitorrepository.MonitorRepositoryPackage
 * @generated
 */
public class MonitorRepositorySwitch<T> extends Switch<T>
{
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static MonitorRepositoryPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MonitorRepositorySwitch()
	{
		if (modelPackage == null)
		{
			modelPackage = MonitorRepositoryPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage)
	{
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject)
	{
		switch (classifierID)
		{
			case MonitorRepositoryPackage.MONITOR_REPOSITORY:
			{
				MonitorRepository monitorRepository = (MonitorRepository)theEObject;
				T result = caseMonitorRepository(monitorRepository);
				if (result == null) result = caseEntity(monitorRepository);
				if (result == null) result = caseIdentifier(monitorRepository);
				if (result == null) result = caseNamedElement(monitorRepository);
				if (result == null) result = casePCMBaseClass(monitorRepository);
				if (result == null) result = casePCMClass(monitorRepository);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MonitorRepositoryPackage.MONITOR:
			{
				Monitor monitor = (Monitor)theEObject;
				T result = caseMonitor(monitor);
				if (result == null) result = caseEntity(monitor);
				if (result == null) result = caseIdentifier(monitor);
				if (result == null) result = caseNamedElement(monitor);
				if (result == null) result = casePCMBaseClass(monitor);
				if (result == null) result = casePCMClass(monitor);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MonitorRepositoryPackage.MEASUREMENT_SPECIFICATION:
			{
				MeasurementSpecification measurementSpecification = (MeasurementSpecification)theEObject;
				T result = caseMeasurementSpecification(measurementSpecification);
				if (result == null) result = caseIdentifier(measurementSpecification);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MonitorRepositoryPackage.STATISTICAL_CHARACTERIZATION:
			{
				StatisticalCharacterization statisticalCharacterization = (StatisticalCharacterization)theEObject;
				T result = caseStatisticalCharacterization(statisticalCharacterization);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MonitorRepositoryPackage.ARITHMETIC_MEAN:
			{
				ArithmeticMean arithmeticMean = (ArithmeticMean)theEObject;
				T result = caseArithmeticMean(arithmeticMean);
				if (result == null) result = caseStatisticalCharacterization(arithmeticMean);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MonitorRepositoryPackage.HARMONIC_MEAN:
			{
				HarmonicMean harmonicMean = (HarmonicMean)theEObject;
				T result = caseHarmonicMean(harmonicMean);
				if (result == null) result = caseStatisticalCharacterization(harmonicMean);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MonitorRepositoryPackage.GEOMETRIC_MEAN:
			{
				GeometricMean geometricMean = (GeometricMean)theEObject;
				T result = caseGeometricMean(geometricMean);
				if (result == null) result = caseStatisticalCharacterization(geometricMean);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MonitorRepositoryPackage.MEDIAN:
			{
				Median median = (Median)theEObject;
				T result = caseMedian(median);
				if (result == null) result = caseStatisticalCharacterization(median);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MonitorRepositoryPackage.PROCESSING_TYPE:
			{
				ProcessingType processingType = (ProcessingType)theEObject;
				T result = caseProcessingType(processingType);
				if (result == null) result = caseIdentifier(processingType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MonitorRepositoryPackage.AGGREGATION:
			{
				Aggregation aggregation = (Aggregation)theEObject;
				T result = caseAggregation(aggregation);
				if (result == null) result = caseProcessingType(aggregation);
				if (result == null) result = caseIdentifier(aggregation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MonitorRepositoryPackage.MEASUREMENT_DRIVEN_AGGREGATION:
			{
				MeasurementDrivenAggregation measurementDrivenAggregation = (MeasurementDrivenAggregation)theEObject;
				T result = caseMeasurementDrivenAggregation(measurementDrivenAggregation);
				if (result == null) result = caseAggregation(measurementDrivenAggregation);
				if (result == null) result = caseProcessingType(measurementDrivenAggregation);
				if (result == null) result = caseIdentifier(measurementDrivenAggregation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MonitorRepositoryPackage.FIXED_SIZE_AGGREGATION:
			{
				FixedSizeAggregation fixedSizeAggregation = (FixedSizeAggregation)theEObject;
				T result = caseFixedSizeAggregation(fixedSizeAggregation);
				if (result == null) result = caseMeasurementDrivenAggregation(fixedSizeAggregation);
				if (result == null) result = caseAggregation(fixedSizeAggregation);
				if (result == null) result = caseProcessingType(fixedSizeAggregation);
				if (result == null) result = caseIdentifier(fixedSizeAggregation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MonitorRepositoryPackage.TIME_DRIVEN_AGGREGATION:
			{
				TimeDrivenAggregation timeDrivenAggregation = (TimeDrivenAggregation)theEObject;
				T result = caseTimeDrivenAggregation(timeDrivenAggregation);
				if (result == null) result = caseTimeDriven(timeDrivenAggregation);
				if (result == null) result = caseAggregation(timeDrivenAggregation);
				if (result == null) result = caseProcessingType(timeDrivenAggregation);
				if (result == null) result = caseIdentifier(timeDrivenAggregation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MonitorRepositoryPackage.TIME_DRIVEN:
			{
				TimeDriven timeDriven = (TimeDriven)theEObject;
				T result = caseTimeDriven(timeDriven);
				if (result == null) result = caseProcessingType(timeDriven);
				if (result == null) result = caseIdentifier(timeDriven);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MonitorRepositoryPackage.VARIABLE_SIZE_AGGREGATION:
			{
				VariableSizeAggregation variableSizeAggregation = (VariableSizeAggregation)theEObject;
				T result = caseVariableSizeAggregation(variableSizeAggregation);
				if (result == null) result = caseMeasurementDrivenAggregation(variableSizeAggregation);
				if (result == null) result = caseAggregation(variableSizeAggregation);
				if (result == null) result = caseProcessingType(variableSizeAggregation);
				if (result == null) result = caseIdentifier(variableSizeAggregation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case MonitorRepositoryPackage.FEED_THROUGH:
			{
				FeedThrough feedThrough = (FeedThrough)theEObject;
				T result = caseFeedThrough(feedThrough);
				if (result == null) result = caseProcessingType(feedThrough);
				if (result == null) result = caseIdentifier(feedThrough);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Monitor Repository</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Monitor Repository</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMonitorRepository(MonitorRepository object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Monitor</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Monitor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMonitor(Monitor object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Measurement Specification</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Measurement Specification</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMeasurementSpecification(MeasurementSpecification object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Statistical Characterization</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Statistical Characterization</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStatisticalCharacterization(StatisticalCharacterization object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Arithmetic Mean</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Arithmetic Mean</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseArithmeticMean(ArithmeticMean object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Harmonic Mean</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Harmonic Mean</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHarmonicMean(HarmonicMean object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Geometric Mean</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Geometric Mean</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGeometricMean(GeometricMean object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Median</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Median</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMedian(Median object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Processing Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Processing Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProcessingType(ProcessingType object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Aggregation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Aggregation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAggregation(Aggregation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Measurement Driven Aggregation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Measurement Driven Aggregation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMeasurementDrivenAggregation(MeasurementDrivenAggregation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Fixed Size Aggregation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Fixed Size Aggregation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFixedSizeAggregation(FixedSizeAggregation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Time Driven Aggregation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Time Driven Aggregation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTimeDrivenAggregation(TimeDrivenAggregation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Time Driven</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Time Driven</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTimeDriven(TimeDriven object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Variable Size Aggregation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Variable Size Aggregation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseVariableSizeAggregation(VariableSizeAggregation object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Feed Through</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Feed Through</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFeedThrough(FeedThrough object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Identifier</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Identifier</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIdentifier(Identifier object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>PCM Class</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>PCM Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePCMClass(PCMClass object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>PCM Base Class</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>PCM Base Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePCMBaseClass(PCMBaseClass object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Named Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Named Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNamedElement(NamedElement object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Entity</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Entity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEntity(Entity object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object)
	{
		return null;
	}

} //MonitorRepositorySwitch
