/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.monitorrepository.statisticalcharacterization;

import java.util.Objects;
import java.util.Optional;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.quantity.Quantity;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.measurementframework.BasicMeasurement;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.metricspec.ScopeOfValidity;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;

public abstract class StatisticalCharacterizationAggregator {
    private final NumericalBaseMetricDescription dataMetric;
    private final Unit<Quantity> dataDefaultUnit;
    private Amount<Duration> intervalLeftBound;
    private Amount<Duration> intervalLength;
    private Amount<Duration> intervalRightBound;
    private static final Amount<Duration> ZERO_DURATION = Amount.valueOf((long)0L, (Unit)Duration.UNIT);

    public StatisticalCharacterizationAggregator(NumericalBaseMetricDescription expectedDataMetric) {
        this.dataMetric = Objects.requireNonNull(expectedDataMetric);
        this.dataDefaultUnit = this.dataMetric.getDefaultUnit();
    }

    public NumericalBaseMetricDescription getDataMetric() {
        return this.dataMetric;
    }

    public Unit<Quantity> getDataDefaultUnit() {
        return this.dataDefaultUnit;
    }

    public final MeasuringValue aggregateData(Iterable<MeasuringValue> data, Amount<Duration> intervalLeftBound, Amount<Duration> intervalRightBound, Optional<Amount<Duration>> intervalLength) {
        Objects.requireNonNull(data);
        this.intervalLeftBound = Objects.requireNonNull(intervalLeftBound);
        this.intervalRightBound = Objects.requireNonNull(intervalRightBound);
        this.intervalLength = Objects.requireNonNull(intervalLength).orElse((Amount<Duration>)this.intervalRightBound.minus(this.intervalLeftBound));
        this.ensureDurationAmountsNonNegative();
        Measure<Double, Quantity> result = null;
        switch (this.dataMetric.getScopeOfValidity()) {
            case CONTINUOUS: {
                result = this.calculateStatisticalCharacterizationContinuous(data);
                break;
            }
            case DISCRETE: {
                result = this.calculateStatisticalCharaterizationDiscrete(data);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return new BasicMeasurement(result, (BaseMetricDescription)this.dataMetric);
    }

    private void ensureDurationAmountsNonNegative() {
        if (this.intervalLeftBound.isLessThan(ZERO_DURATION)) {
            throw new IllegalArgumentException("Interval left bound must not be negative.");
        }
        if (this.intervalRightBound.isLessThan(ZERO_DURATION)) {
            throw new IllegalArgumentException("Interval right bound must not be negative.");
        }
        if (this.intervalLength.isLessThan(ZERO_DURATION)) {
            throw new IllegalArgumentException("Interval length must not be negative.");
        }
    }

    private Measure<Double, Quantity> obtainDataFromMeasurementAsMeasure(MeasuringValue measurement) {
        return measurement.getMeasureForMetric((MetricDescription)this.dataMetric);
    }

    protected final Amount<Duration> getIntervalLength() {
        return this.intervalLength;
    }

    protected final Amount<Quantity> obtainDataFromMeasurement(MeasuringValue measurement) {
        Measure<Double, Quantity> measure = this.obtainDataFromMeasurementAsMeasure(measurement);
        return Amount.valueOf((double)((Double)measure.getValue()), (Unit)measure.getUnit());
    }

    protected final double obtainDataValueFromMeasurement(MeasuringValue measurement) {
        return this.obtainDataFromMeasurementAsMeasure(measurement).doubleValue(this.dataDefaultUnit);
    }

    protected abstract Measure<Double, Quantity> calculateStatisticalCharaterizationDiscrete(Iterable<MeasuringValue> var1);

    protected abstract Measure<Double, Quantity> calculateStatisticalCharacterizationContinuous(Iterable<MeasuringValue> var1);

    private static Amount<Duration> getPointInTimeOfMeasurement(MeasuringValue measurement) {
        assert (measurement != null);
        Measure pointInTimeMeasure = measurement.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
        return Amount.valueOf((double)pointInTimeMeasure.doubleValue((Unit)SI.SECOND), (Unit)SI.SECOND);
    }

    protected final Amount<Duration> obtainCurrentMeasurementValidityLength(MeasuringValue currentMeasurement, Optional<MeasuringValue> nextMeasurement) {
        if (this.dataMetric.getScopeOfValidity() != ScopeOfValidity.CONTINUOUS) {
            throw new IllegalStateException("Method is only reasonable for metrics with continuous scope of validity!");
        }
        Amount<Duration> current = StatisticalCharacterizationAggregator.getPointInTimeOfMeasurement(currentMeasurement);
        Amount<Duration> next = nextMeasurement.map(StatisticalCharacterizationAggregator::getPointInTimeOfMeasurement).orElse(this.intervalRightBound);
        return next.minus(current.isLessThan(this.intervalLeftBound) ? this.intervalLeftBound : current);
    }
}

