/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.probeframework.measurement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RequestContext {
    public static final RequestContext EMPTY_REQUEST_CONTEXT = new RequestContext("");
    private String requestContextId;
    private final RequestContext parentContext;
    private List<RequestContext> childContexts;

    public RequestContext(String requestContextId, RequestContext parentContext) {
        this.requestContextId = requestContextId;
        this.parentContext = parentContext;
        if (parentContext != null) {
            parentContext.addChildContext(this);
        }
        if (this.requestContextId == null) {
            this.requestContextId = "";
        }
    }

    public RequestContext(String requestContextId) {
        this(requestContextId, null);
    }

    public String getRequestContextId() {
        return this.requestContextId;
    }

    public RequestContext getParentContext() {
        return this.parentContext;
    }

    private void addChildContext(RequestContext childContext) {
        if (this.childContexts == null) {
            this.childContexts = new ArrayList<RequestContext>();
        }
        this.childContexts.add(childContext);
    }

    public List<RequestContext> getChildContexts() {
        if (this.childContexts == null) {
            return null;
        }
        return Collections.unmodifiableList(this.childContexts);
    }

    public RequestContext append(String addition) {
        return new RequestContext(String.valueOf(this.getRequestContextId()) + addition, this.getParentContext());
    }

    public RequestContext rootContext() {
        RequestContext context = this;
        while (context.getParentContext() != null) {
            context = context.getParentContext();
        }
        return context;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parentContext == null ? 0 : this.parentContext.hashCode());
        result = 31 * result + (this.requestContextId == null ? 0 : this.requestContextId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestContext)) {
            return false;
        }
        RequestContext other = (RequestContext)obj;
        if (this.parentContext == null ? other.parentContext != null : !this.parentContext.equals(other.parentContext)) {
            return false;
        }
        return !(this.requestContextId == null ? other.requestContextId != null : !this.requestContextId.equals(other.requestContextId));
    }

    public String toString() {
        return this.parentContext != null ? String.valueOf(this.parentContext.toString()) + " called " + "<" + this.requestContextId + ">" : "<" + this.requestContextId + ">";
    }
}

