/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.api.http;

import java.io.IOException;
import java.util.HashMap;
import org.palladiosimulator.protocom.framework.java.ee.prototype.StrategiesRegistry;
import org.palladiosimulator.protocom.framework.java.ee.storage.IStorage;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.CalibrationTable;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.DegreeOfAccuracyEnum;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.IDemandStrategy;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.ResourceTypeEnum;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.cpu.CalculatePrimesDemand;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.cpu.CountNumbersDemand;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.cpu.FFTDemand;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.cpu.FibonacciDemand;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.cpu.MandelbrotDemand;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.cpu.SortArrayDemand;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.cpu.VoidDemand;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.cpu.WaitDemand;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.hdd.ReadLargeChunksDemand;

class StrategyBuilder {
    private static final HashMap<String, Class<?>> CPU = new HashMap();
    private static final HashMap<String, Class<?>> HDD;
    private IStorage storage;

    static {
        CPU.put("primes", CalculatePrimesDemand.class);
        CPU.put("countNumbers", CountNumbersDemand.class);
        CPU.put("fft", FFTDemand.class);
        CPU.put("fibonacci", FibonacciDemand.class);
        CPU.put("mandelbrot", MandelbrotDemand.class);
        CPU.put("sortArray", SortArrayDemand.class);
        CPU.put("void", VoidDemand.class);
        CPU.put("wait", WaitDemand.class);
        HDD = new HashMap();
        HDD.put("largeChunks", ReadLargeChunksDemand.class);
    }

    public StrategyBuilder(IStorage storage) {
        this.storage = storage;
    }

    public IDemandStrategy create(String name, boolean load) {
        IDemandStrategy strategy = null;
        String strategyName = name.substring(4);
        ResourceTypeEnum type = name.startsWith("cpu.") ? ResourceTypeEnum.CPU : ResourceTypeEnum.HDD;
        try {
            switch (type) {
                case CPU: {
                    strategy = (IDemandStrategy)CPU.get(strategyName).newInstance();
                    break;
                }
                case HDD: {
                    strategy = (IDemandStrategy)HDD.get(strategyName).newInstance();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown strategy type");
                }
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (load) {
            byte[] data = null;
            try {
                data = this.storage.readFile("calibration/" + name);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            CalibrationTable table = CalibrationTable.fromBinary(data);
            strategy.setCalibrationTable(table);
        } else {
            strategy.initializeStrategy(DegreeOfAccuracyEnum.MEDIUM, 0.0);
        }
        StrategiesRegistry.getInstance().registerStrategy(type, strategy);
        return strategy;
    }
}

