/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.api.sockets;

import java.util.HashMap;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.palladiosimulator.protocom.framework.java.ee.api.sockets.WebSocket;
import org.palladiosimulator.protocom.framework.java.ee.main.JsonHelper;

@ServerEndpoint(value="/ws/calibration")
public class CalibrationSocket
extends WebSocket {
    private static final Queue<Session> SESSIONS = new ConcurrentLinkedQueue<Session>();
    private static int lastProgress;
    private static String lastMessage;

    private static String buildPayload(int progress, String message) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("progress", progress);
        data.put("message", message);
        return JsonHelper.toJson(data);
    }

    public static void update(int progress, String message) {
        lastProgress = progress = Math.max(0, Math.min(100, progress));
        lastMessage = message;
        String payload = CalibrationSocket.buildPayload(progress, message);
        for (Session session : SESSIONS) {
            CalibrationSocket.send(session, payload);
        }
    }

    @OnOpen
    public void onOpen(Session session, EndpointConfig config) {
        SESSIONS.add(session);
    }

    @OnClose
    public void onClose(Session session, CloseReason reason) {
        SESSIONS.remove(session);
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        String payload = CalibrationSocket.buildPayload(lastProgress, lastMessage);
        CalibrationSocket.send(session, payload);
    }

    @OnError
    public void onError(Session session, Throwable t) {
    }
}

