/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.prototype;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.palladiosimulator.protocom.framework.java.ee.experiment.ExperimentVisitor;
import org.palladiosimulator.protocom.framework.java.ee.modules.ModuleStartException;
import org.palladiosimulator.protocom.framework.java.ee.protocol.RemoteCall;
import org.palladiosimulator.protocom.framework.java.ee.protocol.StringResponse;
import org.palladiosimulator.protocom.framework.java.ee.prototype.ICallVisitor;
import org.palladiosimulator.protocom.framework.java.ee.prototype.IPort;

public abstract class PortServlet<T>
extends HttpServlet
implements IPort<T> {
    private static final long serialVersionUID = 1L;
    protected String location;
    protected T component;
    @Inject
    private ExperimentVisitor experimentVisitor;
    private final List<ICallVisitor> visitors = new LinkedList<ICallVisitor>();

    public void start(String componentId, String assemblyContext) throws ModuleStartException {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse httpResponse) throws ServletException, IOException {
        if (request.getParameter("action").equals("start")) {
            if (this.location == null) {
                this.location = request.getParameter("location");
            }
            StringResponse response = new StringResponse();
            try {
                String assemblyContext = request.getParameter("assemblyContext");
                String innerPortId = request.getParameter("componentId");
                this.addVisitor(this.experimentVisitor);
                this.start(innerPortId, assemblyContext);
                response.setError(0);
            }
            catch (ModuleStartException e) {
                response.setError(3);
            }
            httpResponse.setContentType("application/json");
            httpResponse.getOutputStream().print(response.toJson());
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        StringWriter call = new StringWriter();
        IOUtils.copy((InputStream)request.getInputStream(), (Writer)call);
        RemoteCall remoteCall = RemoteCall.fromJson(call.toString());
        remoteCall.dispatch(this);
    }

    protected void addVisitor(ICallVisitor visitor) {
        this.visitors.add(visitor);
    }

    protected void preCall(String callId) {
        for (ICallVisitor visitor : this.visitors) {
            visitor.preCallVisit(callId);
        }
    }

    protected void postCall(String callId) {
        for (ICallVisitor visitor : this.visitors) {
            visitor.postCallVisit(callId);
        }
    }
}

