/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.resourcestrategies.activeresource.cpu;

import org.palladiosimulator.protocom.resourcestrategies.activeresource.AbstractDemandStrategy;
import org.palladiosimulator.protocom.resourcestrategies.activeresource.ResourceTypeEnum;

public class MandelbrotDemand
extends AbstractDemandStrategy {
    private static final int BAILOUT = 16;
    private static final int MAX_ITERATIONS = 1000;

    public MandelbrotDemand() {
        super(-2, 0, 2, 40, 20);
    }

    private int iterate(float x, float y) {
        float cr = y - 0.5f;
        float ci = x;
        float zi = 0.0f;
        float zr = 0.0f;
        int i = 0;
        do {
            ++i;
            float temp = zr * zi;
            float zr2 = zr * zr;
            float zi2 = zi * zi;
            zr = zr2 - zi2 + cr;
            zi = temp + temp + ci;
            if (!(zi2 + zr2 > 16.0f)) continue;
            return i;
        } while (i <= 1000);
        return 0;
    }

    private void drawMandelbrot(long init) {
        int n = (int)init;
        float m = n;
        int y = -n;
        while (y < n) {
            int x = -n;
            while (x < n) {
                this.iterate((float)x / m, (float)y / m);
                ++x;
            }
            ++y;
        }
    }

    @Override
    public void run(long initial) {
        this.drawMandelbrot(initial);
    }

    @Override
    public ResourceTypeEnum getStrategysResource() {
        return ResourceTypeEnum.CPU;
    }

    @Override
    public String getName() {
        return "Mandelbrot";
    }

    @Override
    public void cleanup() {
    }
}

