/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.recorderframework.sensorframework.strategies;

import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.TimeSpanSensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import javax.measure.Measure;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.palladiosimulator.measurementframework.measureprovider.IMeasureProvider;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.recorderframework.sensorframework.strategies.AbstractWriteDataStrategy;

public class HoldingTimeWriteDataStrategy
extends AbstractWriteDataStrategy {
    public HoldingTimeWriteDataStrategy(IDAOFactory daoFactory, Experiment experiment, ExperimentRun run) {
        super(daoFactory, experiment, run);
    }

    @Override
    public void writeData(IMeasureProvider data) {
        Measure eventTimeMeasure = data.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
        Measure timeSpanMeasure = data.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.HOLDING_TIME_METRIC);
        double eventTime = eventTimeMeasure.doubleValue((Unit)SI.SECOND);
        double timeSpan = timeSpanMeasure.doubleValue((Unit)SI.SECOND);
        this.run.addTimeSpanMeasurement((TimeSpanSensor)this.sensor, eventTime, timeSpan);
    }
}

