/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.recorderframework.filters;

import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MCRWarmUpFilter {
    private static final Logger LOGGER = Logger.getLogger((String)MCRWarmUpFilter.class.getName());
    private int minIndex = 0;

    public List<Double> filter(List<Double> samples) {
        if (samples.size() <= 150 && LOGGER.isEnabledFor((Priority)Level.WARN)) {
            LOGGER.warn((Object)"MCRWarmUpFilter Warning: Too few samples to get a meaningful result.");
        }
        int truncatedSamplesSize = samples.size();
        double truncatedSamplesSum = 0.0;
        for (Double d : samples) {
            truncatedSamplesSum += d.doubleValue();
        }
        double minValue = Double.MAX_VALUE;
        int i = 0;
        while (i < samples.size() - 1) {
            int remaining = samples.size() - i;
            double factor = 1.0 / Math.pow(remaining, 3.0);
            double truncatedSampleMean = truncatedSamplesSum / (double)truncatedSamplesSize;
            double sum = 0.0;
            int j = i + 1;
            while (j < samples.size()) {
                sum += Math.pow(samples.get(j) - truncatedSampleMean, 2.0);
                ++j;
            }
            double d = factor * sum;
            if (d < minValue) {
                this.minIndex = i;
                minValue = d;
            }
            --truncatedSamplesSize;
            truncatedSamplesSum -= samples.get(0).doubleValue();
            ++i;
        }
        if (this.minIndex > samples.size() / 3 && LOGGER.isEnabledFor((Priority)Level.WARN)) {
            LOGGER.warn((Object)"Truncation point is in the last two thirds of the samples, so the confidence in this result is low.");
        }
        return samples.subList(this.minIndex, samples.size() - 1);
    }

    public int getTruncationIndex() {
        return this.minIndex;
    }
}

