/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.solver.pcm2markov;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.pcm.seff.seff_performance.ParametricResourceDemand;
import org.palladiosimulator.reliability.solver.pcm2markov.MarkovResourceState;
import org.palladiosimulator.reliability.solver.pcm2markov.ProcessingResourceDescriptor;
import org.palladiosimulator.solver.core.models.PCMInstance;
import org.palladiosimulator.solver.core.transformations.ContextWrapper;

public class MarkovTransformationSource {
    private static final Logger LOGGER = Logger.getLogger((String)MarkovTransformationSource.class.getName());
    private final PCMInstance model;
    private final List<ProcessingResourceDescriptor> resourceDescriptors;
    private final List<ProcessingResourceDescriptor> unreliableResourceDescriptors;

    public MarkovTransformationSource(PCMInstance model, boolean sortDescriptors) {
        this.model = model;
        this.resourceDescriptors = this.buildResourceDescriptors(sortDescriptors);
        this.unreliableResourceDescriptors = this.buildUnreliableResourceDescriptors();
    }

    private List<ProcessingResourceDescriptor> buildResourceDescriptors(boolean sort) {
        ArrayList<ProcessingResourceDescriptor> resultList = new ArrayList<ProcessingResourceDescriptor>();
        Set resourceContainers = this.model.getUsedResourceContainer();
        for (ResourceContainer container : resourceContainers) {
            if (container.getEntityName().equals("SystemExternalResourceContainer")) continue;
            for (ProcessingResourceSpecification resource : container.getActiveResourceSpecifications_ResourceContainer()) {
                Double resourceMTTF = resource.getMTTF();
                Double resourceMTTR = resource.getMTTR();
                ProcessingResourceType type = resource.getActiveResourceType_ActiveResourceSpecification();
                if (resourceMTTF <= 0.0 || resourceMTTR <= 0.0) {
                    LOGGER.warn((Object)("Improper MTTF/MTTR specification for resource " + type.getEntityName() + " in container " + container.getEntityName() + ": Both values should be positive. Assuming that resource is always ok"));
                    resourceMTTF = 1.0;
                    resourceMTTR = 0.0;
                }
                ProcessingResourceDescriptor descriptor = new ProcessingResourceDescriptor();
                descriptor.setContainerId(container.getId());
                descriptor.setId(type.getId());
                descriptor.setContainerName(container.getEntityName());
                descriptor.setName(type.getEntityName());
                descriptor.setRequiredByContainer(resource.isRequiredByContainer());
                descriptor.setStateProbability(MarkovResourceState.OK, resourceMTTF / (resourceMTTF + resourceMTTR));
                descriptor.setStateProbability(MarkovResourceState.NA, resourceMTTR / (resourceMTTF + resourceMTTR));
                descriptor.setCurrentState(descriptor.getDefaultState());
                resultList.add(descriptor);
            }
        }
        if (sort) {
            this.sort(resultList);
        }
        return resultList;
    }

    private List<ProcessingResourceDescriptor> buildUnreliableResourceDescriptors() {
        ArrayList<ProcessingResourceDescriptor> unreliableResourceDescriptorsList = new ArrayList<ProcessingResourceDescriptor>(this.resourceDescriptors.size());
        int i = 0;
        while (i < this.resourceDescriptors.size()) {
            if (this.resourceDescriptors.get(i).getStateProbability(MarkovResourceState.NA) != 0.0) {
                unreliableResourceDescriptorsList.add(this.resourceDescriptors.get(i));
            }
            ++i;
        }
        return unreliableResourceDescriptorsList;
    }

    public ProcessingResourceDescriptor getDescriptor(ParametricResourceDemand demand, ContextWrapper contextWrapper) {
        ProcessingResourceSpecification resource = contextWrapper.getConcreteProcessingResource(demand);
        if (resource == null) {
            return null;
        }
        String resourceTypeId = resource.getActiveResourceType_ActiveResourceSpecification().getId();
        String containerId = contextWrapper.getAllCtx().getResourceContainer_AllocationContext().getId();
        for (ProcessingResourceDescriptor descriptor : this.resourceDescriptors) {
            if (!descriptor.getType().getId().equals(resourceTypeId) || !descriptor.getResourceContainerId().equals(containerId)) continue;
            return descriptor;
        }
        return null;
    }

    public ProcessingResourceDescriptor getDescriptor(ProcessingResourceSpecification resource) {
        for (ProcessingResourceDescriptor descriptor : this.resourceDescriptors) {
            if (!descriptor.getResourceContainerId().equals(resource.getResourceContainer_ProcessingResourceSpecification().getId()) || !descriptor.getType().getId().equals(resource.getActiveResourceType_ActiveResourceSpecification().getId())) continue;
            return descriptor;
        }
        return null;
    }

    public PCMInstance getModel() {
        return this.model;
    }

    public List<ProcessingResourceDescriptor> getUnreliableResourceDescriptors() {
        return this.unreliableResourceDescriptors;
    }

    public void printCurrentResourceStates() {
        int i = 0;
        while (i < this.unreliableResourceDescriptors.size()) {
            System.out.print(this.unreliableResourceDescriptors.get(i).getCurrentState() == MarkovResourceState.OK ? "1" : "0");
            ++i;
        }
        System.out.println();
    }

    private void sort(List<ProcessingResourceDescriptor> descriptors) {
        Collections.sort(descriptors, new Comparator<ProcessingResourceDescriptor>(){

            @Override
            public int compare(ProcessingResourceDescriptor o1, ProcessingResourceDescriptor o2) {
                if (o1.getStateProbability(MarkovResourceState.NA) > o2.getStateProbability(MarkovResourceState.NA)) {
                    return -1;
                }
                if (o1.getStateProbability(MarkovResourceState.NA) < o2.getStateProbability(MarkovResourceState.NA)) {
                    return 1;
                }
                return 0;
            }
        });
    }
}

