/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability;

import org.palladiosimulator.pcm.reliability.SoftwareInducedFailureType;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.Role;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.reliability.MarkovEvaluationType;
import org.palladiosimulator.reliability.MarkovFailureType;

public class MarkovSoftwareInducedFailureType
extends MarkovFailureType {
    private static String SOFTWARE_ID = "Software-induced failure";
    private static String SOFTWARE_NAME = "Software-induced failure";
    private String componentId = "";
    private String componentName = "";
    private String internalActionId = "";
    private String internalActionName = "";
    private String softwareFailureId = "";
    private String softwareFailureName = "";

    public static MarkovSoftwareInducedFailureType createExternalFailureType(MarkovEvaluationType evaluationType, SoftwareInducedFailureType failureType, Signature signature, Role role, Interface iface) {
        return new MarkovSoftwareInducedFailureType(evaluationType, failureType.getId(), failureType.getEntityName(), signature.getId(), signature.getEntityName(), role.getId(), role.getEntityName(), iface.getId(), iface.getEntityName());
    }

    public static MarkovSoftwareInducedFailureType createExternalFailureType(MarkovEvaluationType evaluationType, String softwareFailureId, String signatureId, String systemRequiredRoleId) {
        return new MarkovSoftwareInducedFailureType(evaluationType, softwareFailureId, "", signatureId, "", systemRequiredRoleId, "", "", "");
    }

    public static MarkovSoftwareInducedFailureType createInternalFailureType(MarkovEvaluationType evaluationType, SoftwareInducedFailureType failureType, InternalAction internalAction, Signature signature, Role role, Interface iface, BasicComponent component) {
        return new MarkovSoftwareInducedFailureType(evaluationType, failureType.getId(), failureType.getEntityName(), internalAction.getId(), internalAction.getEntityName(), signature.getId(), signature.getEntityName(), role.getId(), role.getEntityName(), iface.getId(), iface.getEntityName(), component.getId(), component.getEntityName());
    }

    public static MarkovSoftwareInducedFailureType createInternalFailureType(MarkovEvaluationType evaluationType, String softwareFailureId, String internalActionId) {
        return new MarkovSoftwareInducedFailureType(evaluationType, softwareFailureId, "", internalActionId, "", "", "", "", "", "", "", "", "");
    }

    private MarkovSoftwareInducedFailureType(MarkovEvaluationType evaluationType, String softwareFailureId, String softwareFailureName, String signatureId, String signatureName, String systemRequiredRoleId, String systemRequiredRoleName, String interfaceId, String interfaceName) {
        switch (evaluationType) {
            case POINTSOFFAILURE: {
                this.id = String.valueOf(systemRequiredRoleId) + "/" + signatureId + "/" + softwareFailureId;
                this.name = String.valueOf(systemRequiredRoleName) + "/" + signatureName + "/" + softwareFailureName + " (system-external software-induced failure)";
                break;
            }
            case TYPES: {
                this.id = softwareFailureId;
                this.name = String.valueOf(softwareFailureName) + " (software-induced failure)";
                break;
            }
            case CLASSES: {
                this.id = SOFTWARE_ID;
                this.name = SOFTWARE_NAME;
                break;
            }
            default: {
                this.id = DEFAULT_ID;
                this.name = DEFAULT_NAME;
            }
        }
        this.evaluationType = evaluationType;
        this.softwareFailureId = softwareFailureId;
        this.softwareFailureName = softwareFailureName;
        this.signatureId = signatureId;
        this.signatureName = signatureName;
        this.roleId = systemRequiredRoleId;
        this.roleName = systemRequiredRoleName;
        this.interfaceId = interfaceId;
        this.interfaceName = interfaceName;
        this.systemExternal = true;
    }

    private MarkovSoftwareInducedFailureType(MarkovEvaluationType evaluationType, String softwareFailureId, String softwareFailureName, String internalActionId, String internalActionName, String signatureId, String signatureName, String providedRoleId, String providedRoleName, String interfaceId, String interfaceName, String componentId, String componentName) {
        switch (evaluationType) {
            case POINTSOFFAILURE: {
                this.id = String.valueOf(internalActionId) + "/" + softwareFailureId;
                this.name = String.valueOf(componentName) + "/" + interfaceName + "/" + signatureName + "/" + internalActionName + "/" + softwareFailureName + " (system-internal software-induced failure)";
                break;
            }
            case TYPES: {
                this.id = softwareFailureId;
                this.name = String.valueOf(softwareFailureName) + " (software-induced failure)";
                break;
            }
            case CLASSES: {
                this.id = SOFTWARE_ID;
                this.name = SOFTWARE_NAME;
                break;
            }
            default: {
                this.id = DEFAULT_ID;
                this.name = DEFAULT_NAME;
            }
        }
        this.evaluationType = evaluationType;
        this.softwareFailureId = softwareFailureId;
        this.softwareFailureName = softwareFailureName;
        this.internalActionId = internalActionId;
        this.internalActionName = internalActionName;
        this.signatureId = signatureId;
        this.signatureName = signatureName;
        this.roleId = providedRoleId;
        this.roleName = providedRoleName;
        this.interfaceId = interfaceId;
        this.interfaceName = interfaceName;
        this.componentId = componentId;
        this.componentName = componentName;
        this.systemExternal = false;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getInternalActionId() {
        return this.internalActionId;
    }

    public String getInternalActionName() {
        return this.internalActionName;
    }

    public String getSoftwareFailureId() {
        return this.softwareFailureId;
    }

    public String getSoftwareFailureName() {
        return this.softwareFailureName;
    }
}

