/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.core.gui;

import de.uka.ipd.sdq.workflow.launchconfig.ImageRegistryHelper;
import de.uka.ipd.sdq.workflow.launchconfig.LaunchConfigPlugin;
import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.retriever.core.gui.ServiceConfigurationManager;
import org.palladiosimulator.retriever.core.gui.ServiceConfigurationView;
import org.palladiosimulator.retriever.core.service.AnalystCollection;
import org.palladiosimulator.retriever.core.service.DiscovererCollection;
import org.palladiosimulator.retriever.core.service.EmptyCollection;
import org.palladiosimulator.retriever.core.service.RuleCollection;
import org.palladiosimulator.retriever.services.Analyst;
import org.palladiosimulator.retriever.services.Discoverer;
import org.palladiosimulator.retriever.services.Rule;
import org.palladiosimulator.retriever.services.ServiceCollection;
import org.palladiosimulator.retriever.services.ServiceConfiguration;

public class RetrieverTab
extends AbstractLaunchConfigurationTab {
    public static final String NAME = "Retriever";
    public static final String PLUGIN_ID = "org.palladiosimulator.retriever.core.gui.LaunchRetriever";
    private static final String FILENAME_TAB_IMAGE_PATH = "icons/Retriever_16x16.gif";
    private final String defaultPath = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
    private final ModifyListener modifyListener = e -> {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    };
    private Text in;
    private Text out;
    private final ServiceConfigurationManager<Discoverer> discovererConfigManager;
    private final ServiceConfigurationView<Rule> ruleConfigView;
    private final ServiceConfigurationView<Analyst> analystConfigView;

    public RetrieverTab() {
        Object discovererCollection = null;
        try {
            discovererCollection = new DiscovererCollection();
        }
        catch (CoreException coreException) {
            Logger.getLogger(RetrieverTab.class).error((Object)"Exception occurred while discovering discoverers!");
            discovererCollection = new EmptyCollection();
        }
        ServiceConfiguration discovererConfig = new ServiceConfiguration((ServiceCollection)discovererCollection, "org.palladiosimulator.retriever.core.configuration.discoverers", "org.palladiosimulator.retriever.core.configuration.discovererconfig.");
        this.discovererConfigManager = new ServiceConfigurationManager(discovererConfig);
        Object ruleCollection = null;
        try {
            ruleCollection = new RuleCollection();
        }
        catch (CoreException coreException) {
            Logger.getLogger(RetrieverTab.class).error((Object)"Exception occurred while discovering rules!");
            ruleCollection = new EmptyCollection();
        }
        ServiceConfiguration ruleConfig = new ServiceConfiguration((ServiceCollection)ruleCollection, "org.palladiosimulator.retriever.core.configuration.rules", "org.palladiosimulator.retriever.core.configuration.ruleconfig.");
        ruleConfig.addDependencyProvider(discovererConfig);
        this.ruleConfigView = new ServiceConfigurationView(ruleConfig, this.modifyListener);
        Object analystCollection = null;
        try {
            analystCollection = new AnalystCollection();
        }
        catch (CoreException coreException) {
            Logger.getLogger(RetrieverTab.class).error((Object)"Exception occurred while discovering analysts!");
            analystCollection = new EmptyCollection();
        }
        ServiceConfiguration analystConfig = new ServiceConfiguration((ServiceCollection)analystCollection, "org.palladiosimulator.retriever.core.configuration.analysts", "org.palladiosimulator.retriever.core.configuration.analystconfig.");
        analystConfig.addDependencyProvider(discovererConfig);
        analystConfig.addDependencyProvider(ruleConfig);
        this.analystConfigView = new ServiceConfigurationView(analystConfig, this.modifyListener);
    }

    public Image getImage() {
        return ImageRegistryHelper.getTabImage((String)PLUGIN_ID, (String)FILENAME_TAB_IMAGE_PATH);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout());
        this.in = new Text(container, 2052);
        TabHelper.createFolderInputSection((Composite)container, (ModifyListener)this.modifyListener, (String)"File In", (Text)this.in, (String)"File In", (Shell)this.getShell(), (String)this.defaultPath);
        this.out = new Text(container, 2052);
        TabHelper.createFolderInputSection((Composite)container, (ModifyListener)this.modifyListener, (String)"File Out", (Text)this.out, (String)"File Out", (Shell)this.getShell(), (String)this.defaultPath);
        this.ruleConfigView.createControl(container);
        this.analystConfigView.createControl(container);
    }

    private boolean validateFolderInput(Text widget) {
        if (widget == null || widget.getText() == null || widget.getText().isBlank()) {
            return this.error("Blank input.");
        }
        try {
            URI uri = RetrieverTab.getURI(widget);
            Path path = Paths.get(CommonPlugin.asLocalURI((URI)uri).devicePath(), new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return this.error("The file located by '" + uri + "'does not exist.");
            }
        }
        catch (Exception e) {
            return this.error(e.getLocalizedMessage());
        }
        return this.error(null);
    }

    private boolean error(String message) {
        this.setErrorMessage(message);
        return message == null;
    }

    private static URI getURI(Text widget) {
        String text = URI.decode((String)widget.getText());
        URI uri = URI.createURI((String)text);
        if (uri.isPlatform() || uri.isFile()) {
            return uri;
        }
        return URI.createFileURI((String)text);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.validateFolderInput(this.in) && this.validateFolderInput(this.out);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setText(configuration, this.in, "input.path");
        this.setText(configuration, this.out, "org.palladiosimulator.retriever.core.configuration.output.path");
        this.discovererConfigManager.initializeFrom(configuration);
        this.ruleConfigView.initializeFrom(configuration);
        this.analystConfigView.initializeFrom(configuration);
    }

    private void setText(ILaunchConfiguration configuration, Text textWidget, String attributeName) {
        try {
            textWidget.setText(configuration.getAttribute(attributeName, ""));
        }
        catch (Exception e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)attributeName, (String)e.getMessage());
            this.error(e.getLocalizedMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.setAttribute(configuration, "input.path", this.in);
        this.setAttribute(configuration, "org.palladiosimulator.retriever.core.configuration.output.path", this.out);
        this.discovererConfigManager.performApply(configuration);
        this.ruleConfigView.performApply(configuration);
        this.analystConfigView.performApply(configuration);
    }

    private void setAttribute(ILaunchConfigurationWorkingCopy configuration, String attributeName, Text textWidget) {
        try {
            if (textWidget.getText().isEmpty()) {
                configuration.setAttribute(attributeName, "");
            } else {
                configuration.setAttribute(attributeName, RetrieverTab.getURI(textWidget).toString());
            }
        }
        catch (Exception e) {
            this.error(e.getLocalizedMessage());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.setText(this.in, this.defaultPath);
        this.setAttribute(configuration, "input.path", this.in);
        this.setText(this.out, this.defaultPath);
        this.setAttribute(configuration, "org.palladiosimulator.retriever.core.configuration.output.path", this.out);
        this.discovererConfigManager.setDefaults(configuration);
        this.ruleConfigView.setDefaults(configuration);
        this.analystConfigView.setDefaults(configuration);
    }

    private void setText(Text textWidget, String attributeName) {
        try {
            textWidget.setText(attributeName);
        }
        catch (Exception e) {
            this.error(e.getMessage());
        }
    }

    public String getName() {
        return NAME;
    }
}

