/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.core.main;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.palladiosimulator.generator.fluent.system.api.ISystem;
import org.palladiosimulator.generator.fluent.system.factory.FluentSystemFactory;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.retriever.core.main.RetrieverException;
import org.palladiosimulator.retriever.extraction.engine.DockerParser;
import org.palladiosimulator.retriever.extraction.engine.PCMDetector;
import org.palladiosimulator.retriever.extraction.engine.PCMInstanceCreator;
import org.palladiosimulator.retriever.services.RetrieverConfiguration;
import org.palladiosimulator.retriever.services.Rule;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;

public class Retriever {
    private final RetrieverBlackboard blackboard;
    private static Repository pcm;

    public Retriever(RetrieverBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    public static Repository getPCMRepository() {
        return pcm;
    }

    public void analyze(RetrieverConfiguration configuration, IProgressMonitor progressMonitor) throws RetrieverException {
        try {
            URI in = CommonPlugin.asLocalURI((URI)configuration.getInputFolder());
            Path inPath = Paths.get(in.devicePath(), new String[0]);
            URI out = CommonPlugin.asLocalURI((URI)configuration.getOutputFolder());
            Path outPath = Paths.get(out.devicePath(), new String[0]);
            Set rules = configuration.getConfig(Rule.class).getSelected();
            Retriever.executeWith(inPath, outPath, rules, this.blackboard);
        }
        catch (Exception e) {
            throw new RetrieverException("Analysis did not complete successfully", e);
        }
    }

    public static void executeWith(Path projectPath, Path outPath, List<CompilationUnit> model, Set<Rule> rules) {
        Retriever.executeWith(projectPath, outPath, model, rules);
    }

    private static void executeWith(Path projectPath, Path outPath, Set<Rule> rules, RetrieverBlackboard blackboard) {
        DockerParser dockerParser = new DockerParser(projectPath, (PCMDetector)blackboard.getPCMDetector());
        Map mapping = dockerParser.getMapping();
        pcm = new PCMInstanceCreator(blackboard).createPCM(mapping);
        Map repoCompLocations = blackboard.getRepositoryComponentLocations();
        HashMap<CompilationUnit, RepositoryComponent> invertedEntityLocations = new HashMap<CompilationUnit, RepositoryComponent>();
        for (Map.Entry entry : repoCompLocations.entrySet()) {
            invertedEntityLocations.put((CompilationUnit)entry.getValue(), (RepositoryComponent)entry.getKey());
        }
        FluentSystemFactory create = new FluentSystemFactory();
        for (Map.Entry entry : blackboard.getSystemAssociations().entrySet()) {
            ISystem system = create.newSystem().withName(((Path)entry.getKey()).toString());
            boolean hasChildren = false;
            for (CompilationUnit compUnit : (Set)entry.getValue()) {
                RepositoryComponent repoComp = (RepositoryComponent)invertedEntityLocations.get(compUnit);
                if (repoComp == null) continue;
                system.addToSystem(create.newAssemblyContext().withEncapsulatedComponent(repoComp).withName(repoComp.getEntityName()));
                hasChildren = true;
            }
            if (!hasChildren) continue;
            blackboard.putSystemPath(system.createSystemNow(), (Path)entry.getKey());
        }
        blackboard.addPartition("org.palladiosimulator.retriever.repository", (Object)pcm);
    }

    public static Rule loadRules(String namespace, Path rulesFile) {
        File file = rulesFile.toFile();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (URLClassLoader loader = new URLClassLoader(new URL[]{file.toURI().toURL()});){
                Class<?> c = loader.loadClass(String.valueOf(namespace) + file.getName().replace(".class", ""));
                Object instance = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (instance instanceof Rule) {
                    return (Rule)instance;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

