/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.core.workflow;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;
import org.palladiosimulator.view.plantuml.generator.PcmAllocationDiagramGenerator;
import org.palladiosimulator.view.plantuml.generator.PcmComponentDiagramGenerator;
import org.palladiosimulator.view.plantuml.generator.PcmSystemDiagramGenerator;

public class PlantUmlJob
extends AbstractBlackboardInteractingJob<RetrieverBlackboard> {
    private static final String ALLOCATION_DIAGRAM_NAME = "allocationDiagram.puml";
    private static final String COMPONENT_DIAGRAM_NAME = "componentDiagram.puml";
    private static final String END_UML = "\n@enduml\n";
    private static final String JOB_NAME = "Retriever PlantUML Generation";
    private static final Logger LOGGER = Logger.getLogger(PlantUmlJob.class);
    private static final String START_UML = "@startuml\n";
    private static final String SYSTEM_DIAGRAM_NAME = "systemDiagram.puml";
    private final String allocationKey;
    private final URI outputFolder;
    private final String repositoryKey;
    private final String systemKey;

    public PlantUmlJob(RetrieverBlackboard blackboard, URI outputFolder, String repositoryKey, String systemKey, String allocationKey) {
        super.setBlackboard((Blackboard)Objects.requireNonNull(blackboard));
        this.repositoryKey = Objects.requireNonNull(repositoryKey);
        this.systemKey = Objects.requireNonNull(systemKey);
        this.allocationKey = Objects.requireNonNull(allocationKey);
        this.outputFolder = Objects.requireNonNull(outputFolder);
    }

    public void cleanup(IProgressMonitor arg0) throws CleanupFailedException {
    }

    public void execute(IProgressMonitor arg0) throws JobFailedException, UserCanceledException {
        Allocation allocation;
        System system;
        Repository repository = (Repository)((RetrieverBlackboard)this.getBlackboard()).getPartition(this.repositoryKey);
        if (repository != null && !repository.eContents().isEmpty()) {
            this.writeFile(arg0, START_UML + new PcmComponentDiagramGenerator(repository).get() + END_UML, COMPONENT_DIAGRAM_NAME);
        }
        if ((system = (System)((RetrieverBlackboard)this.getBlackboard()).getPartition(this.systemKey)) != null && !system.eContents().isEmpty()) {
            this.writeFile(arg0, START_UML + new PcmSystemDiagramGenerator(system).get() + END_UML, SYSTEM_DIAGRAM_NAME);
        }
        if ((allocation = (Allocation)((RetrieverBlackboard)this.getBlackboard()).getPartition(this.allocationKey)) != null && !allocation.eContents().isEmpty()) {
            this.writeFile(arg0, START_UML + new PcmAllocationDiagramGenerator(allocation).get() + END_UML, ALLOCATION_DIAGRAM_NAME);
        }
    }

    public String getName() {
        return JOB_NAME;
    }

    private void writeFile(IProgressMonitor monitor, String plantUmlSource, String fileName) {
        if (this.outputFolder.isPlatformResource()) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = root.getFile((IPath)new Path(this.outputFolder.appendSegment(fileName).toPlatformString(true)));
            try {
                if (!file.exists()) {
                    file.create((InputStream)new ByteArrayInputStream(new byte[0]), 1, monitor);
                }
                file.setContents((InputStream)new ByteArrayInputStream(plantUmlSource.getBytes()), 1, monitor);
            }
            catch (CoreException e) {
                LOGGER.error((Object)e);
            }
        } else {
            String path = this.outputFolder.appendSegment(fileName).devicePath();
            try {
                Throwable file = null;
                Object var6_11 = null;
                try (FileWriter writer = new FileWriter(path);){
                    writer.append(plantUmlSource);
                }
                catch (Throwable throwable) {
                    if (file == null) {
                        file = throwable;
                    } else if (file != throwable) {
                        file.addSuppressed(throwable);
                    }
                    throw file;
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        }
    }
}

