/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.core.workflow;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.AbstractBranchTransition;
import org.palladiosimulator.pcm.seff.BranchAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ResourceDemandingSEFF;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;

public class SeffMergerJob
implements IBlackboardInteractingJob<Blackboard<Object>> {
    private static final Logger LOG = Logger.getLogger(SeffMergerJob.class);
    private static final String JOB_NAME = "ServiceEffectSpecification Repository Merger Job";
    private Blackboard<Object> blackboard;
    private final String sourceSeffRepositoryKey;
    private final String destinationSeffRepositoryKey;

    public SeffMergerJob(Blackboard<Object> blackboard, String sourceSeffRepositoryKey, String destinationSeffRepositoryKey) {
        this.blackboard = Objects.requireNonNull(blackboard);
        this.sourceSeffRepositoryKey = sourceSeffRepositoryKey;
        this.destinationSeffRepositoryKey = destinationSeffRepositoryKey;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        monitor.subTask("Retrieving source and destination repository from blackboard");
        Repository sourceRepository = (Repository)this.blackboard.getPartition(this.sourceSeffRepositoryKey);
        Repository destinationRepository = (Repository)this.blackboard.getPartition(this.destinationSeffRepositoryKey);
        monitor.subTask("Merging ServiceEffectSpecificications from source with destination repository");
        for (RepositoryComponent component : sourceRepository.getComponents__Repository()) {
            if (!(component instanceof BasicComponent)) continue;
            BasicComponent sourceComponent = (BasicComponent)component;
            Optional<BasicComponent> destinationComponentOption = destinationRepository.getComponents__Repository().stream().filter(otherComponent -> otherComponent.getEntityName().equals(sourceComponent.getEntityName())).filter(BasicComponent.class::isInstance).map(BasicComponent.class::cast).findFirst();
            if (destinationComponentOption.isEmpty()) {
                LOG.warn((Object)("Failed to find destination component " + sourceComponent.getEntityName() + "!"));
                continue;
            }
            BasicComponent destinationComponent = destinationComponentOption.get();
            List<ServiceEffectSpecification> sourceSeffs = List.copyOf(sourceComponent.getServiceEffectSpecifications__BasicComponent());
            for (ServiceEffectSpecification sourceSeff : sourceSeffs) {
                Optional<OperationSignature> destinationSignatureOption = destinationComponent.getProvidedRoles_InterfaceProvidingEntity().stream().filter(role -> role instanceof OperationProvidedRole).map(role -> (OperationProvidedRole)role).flatMap(role -> role.getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface().stream()).filter(signature -> signature.getEntityName().equals(sourceSeff.getDescribedService__SEFF().getEntityName())).findFirst();
                if (destinationSignatureOption.isEmpty()) {
                    LOG.warn((Object)("Failed to find destination signature for " + sourceSeff.getDescribedService__SEFF().getEntityName() + " in component " + destinationComponent.getEntityName() + "!"));
                    continue;
                }
                OperationSignature destinationSignature = destinationSignatureOption.get();
                sourceSeff.setBasicComponent_ServiceEffectSpecification(destinationComponent);
                sourceSeff.setDescribedService__SEFF((Signature)destinationSignature);
                SeffMergerJob.adaptExternalCallActions((ResourceDemandingBehaviour)((ResourceDemandingSEFF)sourceSeff), destinationRepository, destinationComponent);
                Optional<ServiceEffectSpecification> optionalDestinationSeff = destinationComponent.getServiceEffectSpecifications__BasicComponent().stream().filter(destinationSeff -> destinationSeff.getDescribedService__SEFF().getEntityName().equals(sourceSeff.getDescribedService__SEFF().getEntityName())).findFirst();
                if (!optionalDestinationSeff.isPresent()) continue;
                destinationComponent.getServiceEffectSpecifications__BasicComponent().remove((Object)optionalDestinationSeff.get());
            }
        }
        monitor.done();
    }

    private static void adaptExternalCallActions(ResourceDemandingBehaviour sourceBehaviour, Repository destinationRepository, BasicComponent destinationComponent) {
        EList behaviorSteps = sourceBehaviour.getSteps_Behaviour();
        for (AbstractAction action : behaviorSteps) {
            if (action instanceof BranchAction var6_6) {
                for (AbstractBranchTransition branch : branchAction.getBranches_Branch()) {
                    SeffMergerJob.adaptExternalCallActions(branch.getBranchBehaviour_BranchTransition(), destinationRepository, destinationComponent);
                }
                continue;
            }
            if (!(action instanceof ExternalCallAction)) continue;
            ExternalCallAction externalCallAction = (ExternalCallAction)action;
            String calledSignatureEntityName = externalCallAction.getCalledService_ExternalService().getEntityName();
            Optional<OperationSignature> calledSignatureOption = destinationRepository.getInterfaces__Repository().stream().filter(interFace -> interFace instanceof OperationInterface).flatMap(interFace -> ((OperationInterface)interFace).getSignatures__OperationInterface().stream()).filter(signature -> signature.getEntityName().equals(calledSignatureEntityName)).findFirst();
            if (calledSignatureOption.isEmpty()) {
                LOG.warn((Object)("Failed to find called signature for " + calledSignatureEntityName + "!"));
                continue;
            }
            OperationSignature calledSignature = calledSignatureOption.get();
            Optional<OperationRequiredRole> requiredRoleOption = destinationComponent.getRequiredRoles_InterfaceRequiringEntity().stream().filter(role -> role instanceof OperationRequiredRole).map(role -> (OperationRequiredRole)role).filter(role -> role.getRequiredInterface__OperationRequiredRole().getSignatures__OperationInterface().contains((Object)calledSignature)).findFirst();
            if (requiredRoleOption.isEmpty()) {
                LOG.warn((Object)("Failed to find required role for " + calledSignature.getInterface__OperationSignature().getEntityName() + "#" + calledSignature.getEntityName() + "!"));
                continue;
            }
            OperationRequiredRole requiredRole = requiredRoleOption.get();
            externalCallAction.setCalledService_ExternalService(calledSignature);
            externalCallAction.setRole_ExternalService(requiredRole);
        }
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public String getName() {
        return JOB_NAME;
    }

    public void setBlackboard(Blackboard<Object> blackboard) {
        this.blackboard = Objects.requireNonNull(blackboard);
    }
}

