/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.discoverers;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.csv.CSVFormat;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.retriever.services.Discoverer;
import org.palladiosimulator.retriever.services.RetrieverConfiguration;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;

public class CsvDiscoverer
implements Discoverer {
    private static final String DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.csv";

    public IBlackboardInteractingJob<RetrieverBlackboard> create(final RetrieverConfiguration configuration, final RetrieverBlackboard blackboard) {
        return new AbstractBlackboardInteractingJob<RetrieverBlackboard>(){

            public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
            }

            public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
                Path root = Paths.get(CommonPlugin.asLocalURI((URI)configuration.getInputFolder()).devicePath(), new String[0]);
                this.setBlackboard((Blackboard)Objects.requireNonNull(blackboard));
                HashMap csvs = new HashMap();
                Discoverer.find((Path)root, (String)".csv", (Logger)this.logger).forEach(p -> {
                    LinkedList records = new LinkedList();
                    try {
                        Throwable throwable = null;
                        Object var5_7 = null;
                        try (FileReader reader = new FileReader(p.toFile());){
                            CSVFormat.DEFAULT.parse((Reader)reader).forEach(records::add);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException | IllegalStateException e) {
                        this.logger.error((Object)String.format("%s could not be read correctly.", p), (Throwable)e);
                    }
                    csvs.put(p, records);
                });
                ((RetrieverBlackboard)this.getBlackboard()).putDiscoveredFiles(CsvDiscoverer.DISCOVERER_ID, csvs);
            }

            public String getName() {
                return "CSV Discoverer Job";
            }
        };
    }

    public Set<String> getConfigurationKeys() {
        return Collections.emptySet();
    }

    public String getID() {
        return DISCOVERER_ID;
    }

    public String getName() {
        return "CSV Discoverer";
    }
}

