/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.discoverers;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.palladiosimulator.retriever.services.Discoverer;
import org.palladiosimulator.retriever.services.RetrieverConfiguration;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;

public class XmlDiscoverer
implements Discoverer {
    public static final String DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.xml";

    public IBlackboardInteractingJob<RetrieverBlackboard> create(final RetrieverConfiguration configuration, final RetrieverBlackboard blackboard) {
        return new AbstractBlackboardInteractingJob<RetrieverBlackboard>(){

            public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
            }

            public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
                Path root = Paths.get(CommonPlugin.asLocalURI((URI)configuration.getInputFolder()).devicePath(), new String[0]);
                this.setBlackboard((Blackboard)Objects.requireNonNull(blackboard));
                HashMap xmls = new HashMap();
                Discoverer.find((Path)root, (String)".xml", (Logger)this.logger).forEach(p -> {
                    try {
                        Throwable throwable = null;
                        Object var4_6 = null;
                        try (FileReader reader = new FileReader(p.toFile());){
                            xmls.put(p, new SAXBuilder().build((Reader)reader));
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException | JDOMException e) {
                        this.logger.error((Object)String.format("%s could not be read correctly.", p), e);
                    }
                });
                ((RetrieverBlackboard)this.getBlackboard()).putDiscoveredFiles(XmlDiscoverer.DISCOVERER_ID, xmls);
            }

            public String getName() {
                return "XML Discoverer Job";
            }
        };
    }

    public Set<String> getConfigurationKeys() {
        return Collections.emptySet();
    }

    public String getID() {
        return DISCOVERER_ID;
    }

    public String getName() {
        return "XML Discoverer";
    }
}

