package org.palladiosimulator.retriever.extraction.rules;

import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.core.XtendInjectorSingleton;
import org.eclipse.xtend.core.compiler.batch.XtendBatchCompiler;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.palladiosimulator.retriever.services.RetrieverConfiguration;
import org.palladiosimulator.retriever.services.Rule;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;

@SuppressWarnings("all")
public class ProjectSpecificRulesProxy implements Rule {
  public static final String RULE_ID = "org.palladiosimulator.retriever.extraction.rules.project_specific";

  public static final String LOADED_CLASS_NAME = "org.palladiosimulator.retriever.extraction.rules.ProjectSpecificRules";

  public static final String RULE_PATH_KEY = "xtend_dir_path";

  private Optional<Rule> innerRule = Optional.<Rule>empty();

  @Override
  public IBlackboardInteractingJob<RetrieverBlackboard> create(final RetrieverConfiguration config, final RetrieverBlackboard blackboard) {
    try {
      IBlackboardInteractingJob<RetrieverBlackboard> _xblockexpression = null;
      {
        final File rulesDirectory = this.getConfiguredRulesDirectory(config);
        String _string = rulesDirectory.toString();
        String _plus = (_string + "-xtend-gen");
        final File xtendGenDirectory = new File(_plus);
        if (((!xtendGenDirectory.exists()) && (!xtendGenDirectory.mkdirs()))) {
          throw new IOException(("Could not create intermediate compilation directory at " + xtendGenDirectory));
        }
        this.compileXtend(rulesDirectory, xtendGenDirectory);
        this.compileJava(xtendGenDirectory);
        final URL classDirectoryURL = xtendGenDirectory.toURI().toURL();
        ClassLoader _classLoader = this.getClass().getClassLoader();
        final URLClassLoader classLoader = new URLClassLoader(new URL[] { classDirectoryURL }, _classLoader);
        Object _xtrycatchfinallyexpression = null;
        try {
          Object _xblockexpression_1 = null;
          {
            final Class<?> loadedClass = classLoader.loadClass(ProjectSpecificRulesProxy.LOADED_CLASS_NAME);
            _xblockexpression_1 = loadedClass.getConstructor().newInstance();
          }
          _xtrycatchfinallyexpression = _xblockexpression_1;
        } catch (final Throwable _t) {
          if (_t instanceof ClassNotFoundException) {
            final ClassNotFoundException exception = (ClassNotFoundException)_t;
            throw new IllegalArgumentException(
              ("Could not find project-specific rule. It must have the fully qualified name " + ProjectSpecificRulesProxy.LOADED_CLASS_NAME), exception);
          } else {
            throw Exceptions.sneakyThrow(_t);
          }
        }
        final Object ruleInstance = _xtrycatchfinallyexpression;
        this.innerRule = Optional.<Rule>of(((Rule) ruleInstance));
        _xblockexpression = this.innerRule.get().create(config, blackboard);
      }
      return _xblockexpression;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }

  public File getConfiguredRulesDirectory(final RetrieverConfiguration config) {
    final String configuredValue = config.<Rule>getConfig(Rule.class).getConfig(ProjectSpecificRulesProxy.RULE_ID, ProjectSpecificRulesProxy.RULE_PATH_KEY);
    if (((configuredValue != null) && (!configuredValue.isBlank()))) {
      return new File(configuredValue);
    } else {
      URI _rulesFolder = config.getRulesFolder();
      boolean _tripleNotEquals = (_rulesFolder != null);
      if (_tripleNotEquals) {
        final URI localURI = CommonPlugin.asLocalURI(config.getRulesFolder());
        String _devicePath = localURI.devicePath();
        return new File(_devicePath);
      }
    }
    throw new IllegalArgumentException("No path for project-specific rules is specified");
  }

  public void compileXtend(final File inputDirectory, final File outputDirectory) {
    final XtendBatchCompiler compiler = XtendInjectorSingleton.INJECTOR.<XtendBatchCompiler>getInstance(XtendBatchCompiler.class);
    compiler.setSourcePath(inputDirectory.toString());
    compiler.setOutputPath(outputDirectory.toString());
    compiler.setCurrentClassLoader(this.getClass().getClassLoader());
    compiler.setUseCurrentClassLoaderAsParent(true);
    boolean _compile = compiler.compile();
    boolean _not = (!_compile);
    if (_not) {
      throw new IllegalArgumentException(("Could not compile xtend files located in " + inputDirectory));
    }
  }

  public void compileJava(final File inOutDirectory) {
    final Path sourcePath = inOutDirectory.toPath().resolve("org").resolve("palladiosimulator").resolve("retriever").resolve(
      "extraction").resolve("rules").resolve("ProjectSpecificRules.java");
    String _path = Platform.getInstallLocation().getURL().getPath();
    final Path workingDirectory = new File(_path).toPath();
    final Path jarpath = workingDirectory.resolve("plugins").resolve("*");
    final String classpath = this.buildClassPath(jarpath.toString());
    final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    final StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
    final List<String> compilerOptions = Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList("-classpath", classpath));
    final Iterable<? extends JavaFileObject> sourceFile = fileManager.getJavaFileObjects(sourcePath);
    final JavaCompiler.CompilationTask compilationTask = compiler.getTask(null, fileManager, null, compilerOptions, null, sourceFile);
    Boolean _call = compilationTask.call();
    boolean _not = (!(_call).booleanValue());
    if (_not) {
      throw new IllegalArgumentException(("Could not compile java files generated from xtend files located in " + inOutDirectory));
    }
  }

  /**
   * This function builds a classpath from the passed Strings
   * 
   * @param paths classpath elements
   * @return returns the complete classpath with wildcards expanded
   */
  public String buildClassPath(final String... paths) {
    final StringBuilder sb = new StringBuilder();
    for (final String path : paths) {
      boolean _endsWith = path.endsWith("*");
      if (_endsWith) {
        int _length = path.length();
        int _minus = (_length - 1);
        final String subPath = path.substring(0, _minus);
        final File pathFile = new File(subPath);
        File[] _listFiles = pathFile.listFiles();
        for (final File file : _listFiles) {
          if ((file.isFile() && file.getName().endsWith(".jar"))) {
            sb.append(subPath);
            sb.append(file.getName());
            sb.append(System.getProperty("path.separator"));
          }
        }
      } else {
        sb.append(path);
        sb.append(System.getProperty("path.separator"));
      }
    }
    return sb.toString();
  }

  @Override
  public boolean isBuildRule() {
    return false;
  }

  @Override
  public void processRules(final RetrieverBlackboard blackboard, final Path path) {
    final Consumer<Rule> _function = (Rule x) -> {
      x.processRules(blackboard, path);
    };
    this.innerRule.ifPresent(_function);
  }

  @Override
  public Set<String> getConfigurationKeys() {
    return Set.<String>of(ProjectSpecificRulesProxy.RULE_PATH_KEY);
  }

  @Override
  public Set<String> getDependentServices() {
    return Set.<String>of();
  }

  @Override
  public String getID() {
    return ProjectSpecificRulesProxy.RULE_ID;
  }

  @Override
  public String getName() {
    return "Project-Specific Rules";
  }

  @Override
  public Set<String> getRequiredServices() {
    HashSet<String> _xblockexpression = null;
    {
      final HashSet<String> requirements = new HashSet<String>();
      requirements.add(null);
      _xblockexpression = requirements;
    }
    return _xblockexpression;
  }
}
