/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.commonalities;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.palladiosimulator.retriever.extraction.commonalities.CompUnitOrName;
import org.palladiosimulator.retriever.extraction.commonalities.Provisions;
import org.palladiosimulator.retriever.extraction.commonalities.Requirements;

public class Component {
    private final CompUnitOrName compUnitOrName;
    private final Requirements requirements;
    private final Provisions provisions;
    private final Optional<String> separatingIdentifier;

    public Component(CompUnitOrName compUnitOrName, Requirements requirements, Provisions provisions, Optional<String> separatingIdentifier) {
        this.compUnitOrName = compUnitOrName;
        this.requirements = requirements;
        this.provisions = provisions;
        this.separatingIdentifier = separatingIdentifier;
    }

    public Requirements requirements() {
        return this.requirements;
    }

    public Provisions provisions() {
        return this.provisions;
    }

    public Optional<CompilationUnit> compilationUnit() {
        return this.compUnitOrName.compilationUnit();
    }

    public String name() {
        return this.compUnitOrName.name();
    }

    public CompUnitOrName identifier() {
        return this.compUnitOrName;
    }

    public Optional<String> separatingIdentifier() {
        return this.separatingIdentifier;
    }

    public int hashCode() {
        return Objects.hash(this.compUnitOrName, this.provisions, this.requirements);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Component other = (Component)obj;
        return Objects.equals(this.compUnitOrName, other.compUnitOrName) && Objects.equals(this.provisions, other.provisions) && Objects.equals(this.requirements, other.requirements);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Name: ");
        builder.append(this.name());
        builder.append("\nRequirements:\n\t");
        builder.append(this.requirements.toString().replace("\n", "\n\t"));
        builder.append("\nProvisions:\n\t");
        builder.append(this.provisions.toString().replace("\n", "\n\t"));
        return builder.toString();
    }
}

